/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.common.base.Patchouli;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static String getEntityName(String entityId) {
        Pair<String, String> nameAndNbt = EntityUtil.splitNameAndNBT(entityId);
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation((String)nameAndNbt.getLeft()));
        return type.func_210760_d();
    }

    public static Function<World, Entity> loadEntity(String entityId) {
        ResourceLocation key;
        Pair<String, String> nameAndNbt = EntityUtil.splitNameAndNBT(entityId);
        entityId = (String)nameAndNbt.getLeft();
        String nbtStr = (String)nameAndNbt.getRight();
        CompoundNBT nbt = null;
        if (!nbtStr.isEmpty()) {
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtStr);
            }
            catch (CommandSyntaxException e) {
                Patchouli.LOGGER.error("Failed to load entity data", (Throwable)e);
            }
        }
        if (!ForgeRegistries.ENTITIES.containsKey(key = new ResourceLocation(entityId))) {
            throw new RuntimeException("Unknown entity id: " + entityId);
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(key);
        CompoundNBT useNbt = nbt;
        String useId = entityId;
        return world -> {
            try {
                Entity entity = type.func_200721_a(world);
                if (useNbt != null) {
                    entity.func_70020_e(useNbt);
                }
                return entity;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't load entity " + useId, e);
            }
        };
    }

    private static Pair<String, String> splitNameAndNBT(String entityId) {
        int nbtStart = entityId.indexOf("{");
        String nbtStr = "";
        if (nbtStart > 0) {
            nbtStr = entityId.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            entityId = entityId.substring(0, nbtStart);
        }
        return Pair.of((Object)entityId, (Object)nbtStr);
    }
}

