/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidFilterManager
implements IFilterManager {
    @Override
    public ItemFilter createFilter(ItemStack stack) {
        return new FluidFilter(stack);
    }

    @Override
    public ItemFilter readFilter(CompoundNBT compound) {
        return new FluidFilter(compound);
    }

    private static class FluidFilter
    extends ItemFilter {
        FluidStack stack;

        public FluidFilter(ItemStack stack) {
            this.stack = FluidFilter.getFluid(stack);
            if (this.stack != null) {
                this.stack = this.stack.copy();
            }
        }

        public FluidFilter(CompoundNBT compound) {
            this.stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound);
        }

        @Override
        public boolean matches(Object stack) {
            FluidStack fluid = stack instanceof FluidStack ? (FluidStack)stack : (stack instanceof ItemStack ? FluidFilter.getFluid((ItemStack)stack) : null);
            return fluid != null && fluid.isFluidEqual(this.stack);
        }

        @Override
        public ItemStack getRepresentingItem() {
            return new ItemStack((IItemProvider)this.stack.getFluid().func_204524_b());
        }

        @Override
        public CompoundNBT write() {
            return this.stack.writeToNBT(new CompoundNBT());
        }

        @Override
        public boolean isValid() {
            return this.stack != null && !this.stack.isEmpty();
        }

        private static FluidStack getFluid(ItemStack stack) {
            IFluidHandler fluidHandler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
            return fluidHandler == null || fluidHandler.getTanks() != 1 || fluidHandler.getFluidInTank(0).isEmpty() ? null : fluidHandler.getFluidInTank(0);
        }
    }
}

