/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.network.AbstractModMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ErrorReportMessage
extends AbstractModMessage {
    private final List<ITextComponent> _errors;
    private final BlockPos _position;

    public static ErrorReportMessage create(@Nullable BlockPos position, ITextComponent ... errors) {
        return new ErrorReportMessage(position, errors);
    }

    public static ErrorReportMessage create(@Nullable BlockPos position, List<ITextComponent> errors) {
        return new ErrorReportMessage(position, errors);
    }

    public ErrorReportMessage(PacketBuffer buffer) {
        super(buffer);
        int count = buffer.readInt();
        this._errors = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            this._errors.add(buffer.func_179258_d());
        }
        this._position = buffer.readBoolean() ? buffer.func_179259_c() : null;
    }

    @Override
    public void encodeTo(PacketBuffer buffer) {
        buffer.writeInt(this._errors.size());
        this._errors.forEach(arg_0 -> ((PacketBuffer)buffer).func_179256_a(arg_0));
        if (null == this._position) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_179255_a(this._position);
        }
    }

    @Override
    public void processMessage(NetworkEvent.Context messageContext) {
        if (NetworkDirection.PLAY_TO_CLIENT == messageContext.getDirection()) {
            ZeroCore.getProxy().reportErrorToPlayer(null, this._position, this._errors);
        }
    }

    protected ErrorReportMessage(@Nullable BlockPos position, ITextComponent ... errors) {
        this(position, Lists.newArrayList((Object[])errors));
    }

    protected ErrorReportMessage(@Nullable BlockPos position, List<ITextComponent> errors) {
        this._errors = Lists.newArrayList(errors);
        this._position = position;
    }
}

