/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteBuilder;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class AtlasSpriteTextureMap
implements ISpriteTextureMap {
    public static final AtlasSpriteTextureMap BLOCKS = new AtlasSpriteTextureMap(PlayerContainer.field_226615_c_);
    private final ResourceLocation _atlasName;
    private int _atlasWidth;
    private int _atlasHeight;
    private static final Field s_xField = AtlasSpriteTextureMap.getField("field_110975_c");
    private static final Field s_yField = AtlasSpriteTextureMap.getField("field_110974_d");

    public static AtlasSpriteTextureMap from(TextureAtlasSprite sprite) {
        ResourceLocation id = sprite.func_229241_m_().func_229223_g_();
        if (BLOCKS.getTextureLocation().equals((Object)id)) {
            return BLOCKS;
        }
        return new AtlasSpriteTextureMap(id);
    }

    public AtlasSpriteTextureMap(ResourceLocation atlasName) {
        this._atlasName = atlasName;
        this._atlasHeight = -1;
        this._atlasWidth = -1;
    }

    public ISprite sprite(ResourceLocation spriteName) {
        return this.sprite((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(this._atlasName).apply(spriteName));
    }

    public ISprite sprite(TextureAtlasSprite sprite, ISprite overlay) {
        return this.makeSprite(sprite, overlay);
    }

    public ISprite sprite(TextureAtlasSprite sprite) {
        return this.makeSprite(sprite, null);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this._atlasName;
    }

    @Override
    public int getWidth() {
        return this._atlasWidth;
    }

    @Override
    public int getHeight() {
        return this._atlasHeight;
    }

    @Override
    public ISpriteBuilder sprite() {
        throw new UnsupportedOperationException();
    }

    private ISprite makeSprite(TextureAtlasSprite sprite, @Nullable ISprite overlay) {
        int spriteX = -1;
        int spriteY = -1;
        try {
            spriteX = s_xField.getInt(sprite);
            spriteY = s_yField.getInt(sprite);
        }
        catch (IllegalAccessException e) {
            Log.LOGGER.warn(Log.CORE, "Unable to get the value of field x or y for a TextureAtlasSprite");
        }
        if (this._atlasHeight < 0 || this._atlasWidth < 0) {
            this._atlasWidth = (int)((float)spriteX / sprite.func_94209_e());
            this._atlasHeight = (int)((float)spriteY / sprite.func_94206_g());
        }
        return new AtlasSprite(this, sprite, spriteX, spriteY, overlay);
    }

    @Nullable
    private static Field getField(String name) {
        try {
            return ObfuscationReflectionHelper.findField(TextureAtlasSprite.class, (String)name);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
            Log.LOGGER.error(Log.CORE, "AtlasSpriteTextureMap - Unable to get field {} : {}", (Object)name, (Object)ex);
            return null;
        }
    }

    static class AtlasSprite
    implements ISprite {
        private final ISpriteTextureMap _map;
        private final TextureAtlasSprite _atlasSprite;
        private final ISprite _overlay;
        private final int _u;
        private final int _v;

        public AtlasSprite(ISpriteTextureMap textureMap, TextureAtlasSprite sprite, int u, int v, @Nullable ISprite overlay) {
            this._map = textureMap;
            this._atlasSprite = sprite;
            this._overlay = overlay;
            this._u = u;
            this._v = v;
        }

        @Override
        public int getWidth() {
            return this._atlasSprite.func_94211_a();
        }

        @Override
        public int getHeight() {
            return this._atlasSprite.func_94216_b();
        }

        @Override
        public int getU() {
            return this._u;
        }

        @Override
        public int getV() {
            return this._v;
        }

        @Override
        public float getMinU() {
            return this._atlasSprite.func_94209_e();
        }

        @Override
        public float getMaxU() {
            return this._atlasSprite.func_94212_f();
        }

        @Override
        public float getMinV() {
            return this._atlasSprite.func_94206_g();
        }

        @Override
        public float getMaxV() {
            return this._atlasSprite.func_94210_h();
        }

        @Override
        public Optional<TextureAtlasSprite> getAtlasSprite() {
            return Optional.of(this._atlasSprite);
        }

        @Override
        public ISpriteTextureMap getTextureMap() {
            return this._map;
        }

        @Override
        public Optional<ISprite> getSpriteOverlay() {
            return Optional.ofNullable(this._overlay);
        }

        @Override
        public void applyOverlay(NonNullConsumer<ISprite> overlayConsumer) {
            if (null != this._overlay) {
                overlayConsumer.accept((Object)this._overlay);
            }
        }

        @Override
        public ISprite copy() {
            return new AtlasSprite(this);
        }

        @Override
        public ISprite copyWith(ISprite overlay) {
            return new AtlasSprite(this, overlay);
        }

        protected AtlasSprite(AtlasSprite other) {
            this(other, null);
        }

        protected AtlasSprite(AtlasSprite other, @Nullable ISprite overlay) {
            this._map = other._map;
            this._atlasSprite = other._atlasSprite;
            this._overlay = overlay;
            this._u = other._u;
            this._v = other._v;
        }
    }
}

