/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.zerono.mods.zerocore.lib.client.render.DisplayList;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CachedRender {
    private DisplayList _list;

    public void paint(double x, double y, double z) {
        if (null == this._list) {
            this._list = new DisplayList();
            this._list.beginList();
            this.buildRender();
            this._list.endList();
        }
        this.onBeginPainting(x, y, z);
        ModRenderHelper.bindTexture(this.getTexture());
        this._list.play();
        this.onEndPainting(x, y, z);
    }

    public void invalidate() {
        this._list = null;
    }

    protected abstract ResourceLocation getTexture();

    protected abstract void buildRender();

    protected void onBeginPainting(double x, double y, double z) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)z);
    }

    protected void onEndPainting(double x, double y, double z) {
        RenderSystem.translated((double)(-x), (double)(-y), (double)(-z));
        RenderSystem.popMatrix();
    }
}

