/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import java.util.EnumSet;
import java.util.stream.Collectors;

public class Flags<E extends Enum<E>> {
    private final EnumSet<E> _flags;

    public Flags(Class<E> enumClass) {
        this._flags = EnumSet.noneOf(enumClass);
    }

    @SafeVarargs
    public Flags(E value, E ... others) {
        this._flags = EnumSet.of(value, others);
    }

    public boolean contains(E flag) {
        return this._flags.contains(flag);
    }

    public void add(E flag) {
        this._flags.add(flag);
    }

    public void addIf(E flag, boolean add) {
        if (add) {
            this.add(flag);
        }
    }

    public void remove(E flag) {
        this._flags.remove(flag);
    }

    public void removeIf(E flag, boolean remove) {
        if (remove) {
            this.remove(flag);
        }
    }

    public void set(E flag, boolean active) {
        if (active) {
            this.add(flag);
        } else {
            this.remove(flag);
        }
    }

    public void flip(E flag) {
        this.set(flag, !this.contains(flag));
    }

    public String toString() {
        return this._flags.stream().map(Enum::name).collect(Collectors.joining(", "));
    }
}

