/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import com.google.common.base.Strings;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class NBTBuilder {
    private final CompoundNBT _root = new CompoundNBT();

    public CompoundNBT build() {
        return this._root;
    }

    public NBTBuilder merge(NBTBuilder builder) {
        this._root.func_197643_a(builder.build());
        return this;
    }

    public NBTBuilder merge(CompoundNBT compound) {
        this._root.func_197643_a(compound);
        return this;
    }

    public NBTBuilder addEntity(String name, ISyncableEntity entity, ISyncableEntity.SyncReason syncReason) {
        NBTBuilder.validateName(name);
        this._root.func_218657_a(name, (INBT)entity.syncDataTo(new CompoundNBT(), syncReason));
        return this;
    }

    public NBTBuilder addCompound(String name, Consumer<NBTBuilder> builder) {
        NBTBuilder.validateName(name);
        NBTBuilder b = new NBTBuilder();
        builder.accept(b);
        this._root.func_218657_a(name, (INBT)b.build());
        return this;
    }

    public NBTBuilder addByte(String name, byte value) {
        NBTBuilder.validateName(name);
        this._root.func_74774_a(name, value);
        return this;
    }

    public NBTBuilder addShort(String name, short value) {
        NBTBuilder.validateName(name);
        this._root.func_74777_a(name, value);
        return this;
    }

    public NBTBuilder addInteger(String name, int value) {
        NBTBuilder.validateName(name);
        this._root.func_74768_a(name, value);
        return this;
    }

    public NBTBuilder addLong(String name, long value) {
        NBTBuilder.validateName(name);
        this._root.func_74772_a(name, value);
        return this;
    }

    public NBTBuilder addFloat(String name, float value) {
        NBTBuilder.validateName(name);
        this._root.func_74776_a(name, value);
        return this;
    }

    public NBTBuilder addDouble(String name, double value) {
        NBTBuilder.validateName(name);
        this._root.func_74780_a(name, value);
        return this;
    }

    public NBTBuilder addBoolean(String name, boolean value) {
        NBTBuilder.validateName(name);
        this._root.func_74757_a(name, value);
        return this;
    }

    public NBTBuilder addString(String name, String value) {
        NBTBuilder.validateName(name);
        this._root.func_74778_a(name, value);
        return this;
    }

    public NBTBuilder addByteArray(String name, byte[] value) {
        NBTBuilder.validateName(name);
        this._root.func_74773_a(name, value);
        return this;
    }

    public NBTBuilder addIntArray(String name, int[] value) {
        NBTBuilder.validateName(name);
        this._root.func_74783_a(name, value);
        return this;
    }

    public NBTBuilder addIntArray(String name, List<Integer> value) {
        NBTBuilder.validateName(name);
        this._root.func_197646_b(name, value);
        return this;
    }

    public NBTBuilder addLongArray(String name, long[] value) {
        NBTBuilder.validateName(name);
        this._root.func_197644_a(name, value);
        return this;
    }

    public NBTBuilder addLongArray(String name, List<Long> value) {
        NBTBuilder.validateName(name);
        this._root.func_202168_c(name, value);
        return this;
    }

    public NBTBuilder addUniqueId(String name, UUID value) {
        NBTBuilder.validateName(name);
        this._root.func_186854_a(name, value);
        return this;
    }

    private static void validateName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid tag name");
        }
    }
}

