/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.datagen.LootTableType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;

public class BaseLootTableProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final LootTableType _type;
    private final DataGenerator _generator;
    private final Map<ResourceLocation, LootTable.Builder> _tables;

    protected BaseLootTableProvider(LootTableType type, DataGenerator dataGenerator) {
        this._type = type;
        this._generator = dataGenerator;
        this._tables = Maps.newHashMap();
    }

    public LootTableType getType() {
        return this._type;
    }

    protected void generateTables() {
    }

    protected void add(ResourceLocation id, LootTable.Builder builder) {
        if (null != this._tables.put(id, builder)) {
            Log.LOGGER.error(Log.CORE, "Loot table provider - {} table {} already exist!", (Object)this.getType(), (Object)id);
        }
    }

    protected void addEmpty(ResourceLocation id) {
        this.add(id, LootTable.func_216119_b());
    }

    public void func_200398_a(DirectoryCache cache) {
        this.generateTables();
        this._tables.forEach((id, builder) -> this.writeTable(cache, (ResourceLocation)id, builder.func_216039_a(this.getType().getParameters()).func_216038_b()));
    }

    public String func_200397_b() {
        return "";
    }

    private void writeTable(DirectoryCache cache, ResourceLocation id, LootTable table) {
        Path path = this._generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/loot_tables/" + this.getType().getSubFolderName() + "/" + id.func_110623_a() + ".json");
        try {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)path);
        }
        catch (IOException ex) {
            Log.LOGGER.error(Log.CORE, "Loot table provider - couldn't write tables at {}", (Object)path, (Object)ex);
        }
    }
}

