/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.LogicalSide;

public class EnergyBuffer
implements IWideEnergyStorage,
ISyncableEntity,
IDebuggable {
    private final EnergySystem _system;
    private double _energy;
    private double _capacity;
    private double _maxInsert;
    private double _maxExtract;

    public EnergyBuffer(EnergySystem system, double capacity) {
        this(system, capacity, capacity, capacity);
    }

    public EnergyBuffer(EnergySystem system, double capacity, double maxTransfer) {
        this(system, capacity, maxTransfer, maxTransfer);
    }

    public EnergyBuffer(EnergySystem system, double capacity, double maxInsert, double maxExtract) {
        this._system = system;
        this._energy = 0.0;
        this.setCapacity(capacity);
        this.setMaxInsert(maxInsert);
        this.setMaxExtract(maxExtract);
    }

    public EnergyBuffer setCapacity(double capacity) {
        this._capacity = Math.max(0.0, capacity);
        this.clampEnergyToCapacity();
        return this;
    }

    public EnergyBuffer setMaxTransfer(double maxTransfer) {
        this.setMaxInsert(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public EnergyBuffer setMaxInsert(double maxInsert) {
        this._maxInsert = Math.max(0.0, maxInsert);
        return this;
    }

    public EnergyBuffer setMaxExtract(double maxExtract) {
        this._maxExtract = Math.max(0.0, maxExtract);
        return this;
    }

    public double getMaxInsert() {
        return this._maxInsert;
    }

    public double getMaxExtract() {
        return this._maxExtract;
    }

    public double getEnergyStored() {
        return this._energy;
    }

    public EnergyBuffer setEnergyStored(double amount) {
        this._energy = Math.max(0.0, amount);
        this.clampEnergyToCapacity();
        return this;
    }

    public EnergyBuffer modifyEnergyStored(double amount) {
        if (Double.isNaN(amount)) {
            return this;
        }
        this._energy += amount;
        this.clampEnergyToCapacity();
        if (this._energy < 0.0) {
            this._energy = 0.0;
        }
        return this;
    }

    public double getEnergyStoredPercentage() {
        return this.getEnergyStored() / this._capacity;
    }

    @Override
    public EnergySystem getEnergySystem() {
        return this._system;
    }

    @Override
    public double insertEnergy(EnergySystem system, double maxAmount, boolean simulate) {
        if (!this.canInsert()) {
            return 0.0;
        }
        EnergySystem localSystem = this.getEnergySystem();
        maxAmount = system.convertTo(localSystem, maxAmount);
        double inserted = Math.min(this.getCapacity(localSystem) - this.getEnergyStored(localSystem), Math.min(this.getMaxInsert(), maxAmount));
        if (!simulate) {
            this.modifyEnergyStored(inserted);
        }
        return localSystem.convertTo(system, inserted);
    }

    @Override
    public double extractEnergy(EnergySystem system, double maxAmount, boolean simulate) {
        if (!this.canExtract()) {
            return 0.0;
        }
        EnergySystem localSystem = this.getEnergySystem();
        maxAmount = system.convertTo(localSystem, maxAmount);
        double extracted = Math.min(this.getEnergyStored(localSystem), Math.min(this.getMaxExtract(), maxAmount));
        if (!simulate) {
            this.modifyEnergyStored(-extracted);
        }
        return localSystem.convertTo(system, extracted);
    }

    @Override
    public double getEnergyStored(EnergySystem system) {
        return this.convertIf(system, this._energy);
    }

    @Override
    public double getCapacity(EnergySystem system) {
        return this.convertIf(system, this._capacity);
    }

    @Override
    public boolean canExtract() {
        return this.getMaxExtract() > 0.0;
    }

    @Override
    public boolean canInsert() {
        return this.getMaxInsert() > 0.0;
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this.setCapacity(data.func_74769_h("capacity"));
        this.setMaxInsert(data.func_74769_h("maxInsert"));
        this.setMaxExtract(data.func_74769_h("maxExtract"));
        this.setEnergyStored(data.func_74769_h("energy"));
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        EnergySystem localSystem = this.getEnergySystem();
        data.func_74780_a("capacity", this.getCapacity(localSystem));
        data.func_74780_a("maxInsert", this.getMaxInsert());
        data.func_74780_a("maxExtract", this.getMaxExtract());
        data.func_74780_a("energy", this.getEnergyStored(localSystem));
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        EnergySystem sys = this.getEnergySystem();
        messages.add("Energy buffer: %1$s / %2$s; Imax: %3$s/t, Omax: %4$s/t", sys.asHumanReadableNumber(this.getEnergyStored(sys)), sys.asHumanReadableNumber(this.getCapacity(sys)), sys.asHumanReadableNumber(this.getMaxInsert()), sys.asHumanReadableNumber(this.getMaxExtract()));
    }

    public String toString() {
        EnergySystem sys = this.getEnergySystem();
        return String.format("%s / %s - Imax: %s/t, Omax: %s/t", sys.asHumanReadableNumber(this.getEnergyStored(sys)), sys.asHumanReadableNumber(this.getCapacity(sys)), sys.asHumanReadableNumber(this.getMaxInsert()), sys.asHumanReadableNumber(this.getMaxExtract()));
    }

    private void clampEnergyToCapacity() {
        double capacity = this.getCapacity(this.getEnergySystem());
        if (this._energy > capacity) {
            this._energy = capacity;
        }
    }

    private double convertIf(EnergySystem system, double amount) {
        return this.getEnergySystem() != system ? this.getEnergySystem().convertTo(system, amount) : amount;
    }
}

