/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public final class FluidHelper {
    public static final IFluidHandler EMPTY_FLUID_HANDLER = EmptyFluidHandler.INSTANCE;

    public static ResourceLocation getFluidId(Fluid fluid) {
        return Objects.requireNonNull(fluid.getRegistryName());
    }

    public static ResourceLocation getFluidId(FluidStack stack) {
        return Objects.requireNonNull(stack.getFluid().getRegistryName());
    }

    public static FluidStack tryFluidTransfer(IFluidHandler source, World world, BlockPos destinationPosition, Direction fillDirection, int maxAmount, IFluidHandler.FluidAction action) {
        return FluidUtil.getFluidHandler((World)world, (BlockPos)destinationPosition, (Direction)fillDirection).map(destination -> FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)maxAmount, (boolean)action.execute())).orElse(FluidStack.EMPTY);
    }

    public static FluidStack stackFrom(CompoundNBT nbt) {
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
    }

    public static CompoundNBT stackToNBT(FluidStack stack) {
        return stack.writeToNBT(new CompoundNBT());
    }

    public static FluidStack stackFrom(JsonElement json) {
        JsonObject o = json.getAsJsonObject();
        Fluid fluid = JSONHelper.jsonGetFluid(o, "fluid");
        int count = JSONHelper.jsonGetInt(o, "count", 1);
        if (o.has("nbt")) {
            return new FluidStack(fluid, count, JSONHelper.jsonGetNBT(o, "nbt"));
        }
        return new FluidStack(fluid, count);
    }

    public static JsonElement stackToJSON(FluidStack stack) {
        JsonObject json = new JsonObject();
        int count = stack.getAmount();
        JSONHelper.jsonSetFluid(json, "fluid", stack.getFluid());
        JSONHelper.jsonSetInt(json, "count", count);
        if (stack.hasTag()) {
            JSONHelper.jsonSetNBT(json, "nbt", Objects.requireNonNull(stack.getTag()));
        }
        return json;
    }

    public static String toStringHelper(FluidStack stack) {
        return "FluidStack: " + stack.getAmount() + ' ' + stack.getFluid().getRegistryName();
    }

    private FluidHelper() {
    }
}

