/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.network.AbstractModMessage;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class AbstractModTileMessage
extends AbstractModMessage {
    private final BlockPos _tilePosition;
    private final RegistryKey<World> _dimension;

    protected AbstractModTileMessage(PacketBuffer buffer) {
        this._dimension = buffer.readBoolean() ? RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buffer.func_150789_c(4096))) : null;
        this._tilePosition = buffer.func_179259_c();
    }

    public BlockPos getTileEntityPosition() {
        return this._tilePosition;
    }

    public Optional<RegistryKey<World>> getDimension() {
        return Optional.ofNullable(this._dimension);
    }

    protected abstract void processTileEntityMessage(LogicalSide var1, TileEntity var2);

    @Override
    public void encodeTo(PacketBuffer buffer) {
        if (null != this._dimension) {
            buffer.writeBoolean(true);
            buffer.func_192572_a(this._dimension.func_240901_a_());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.func_179255_a(this._tilePosition);
    }

    @Override
    public void processMessage(NetworkEvent.Context messageContext) {
        BlockPos position = this.getTileEntityPosition();
        CodeHelper.optionalIfPresentOrElse(this.getWorld(messageContext), w -> CodeHelper.optionalIfPresentOrElse(WorldHelper.getTile(w, position), tile -> this.processTileEntityMessage(messageContext.getDirection().getOriginationSide(), (TileEntity)tile), () -> Log.LOGGER.error(Log.NETWORK, "No tile entity found at {}, {}, {} while processing a ModTileEntityMessage: skipping message", (Object)position.func_177958_n(), (Object)position.func_177956_o(), (Object)position.func_177952_p())), () -> Log.LOGGER.error(Log.NETWORK, "Invalid world instance found while processing a ModTileEntityMessage: skipping message"));
    }

    protected AbstractModTileMessage(BlockPos tileEntityPosition) {
        this._tilePosition = tileEntityPosition;
        this._dimension = null;
    }

    protected AbstractModTileMessage(BlockPos tileEntityPosition, RegistryKey<World> dimension) {
        this._tilePosition = tileEntityPosition;
        this._dimension = dimension;
    }

    private Optional<World> getWorld(NetworkEvent.Context messageContext) {
        switch (messageContext.getDirection()) {
            case PLAY_TO_CLIENT: {
                return WorldHelper.getClientWorld();
            }
            case PLAY_TO_SERVER: {
                ServerPlayerEntity player = messageContext.getSender();
                if (null == player) break;
                if (null != this._dimension) {
                    return WorldHelper.getServerWorld(this._dimension).map(sw -> sw);
                }
                return Optional.of(player.func_130014_f_());
            }
        }
        return Optional.empty();
    }
}

