/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.nbt.INestedSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.network.AbstractModTileMessage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;

public class ModSyncableTileMessage
extends AbstractModTileMessage {
    private final CompoundNBT _payload;
    private final boolean _nested;

    public static ModSyncableTileMessage create(BlockPos tileEntityPosition, ISyncableEntity entity) {
        return new ModSyncableTileMessage(tileEntityPosition, entity, false);
    }

    public static ModSyncableTileMessage create(BlockPos tileEntityPosition, INestedSyncableEntity entity) {
        return new ModSyncableTileMessage(tileEntityPosition, entity.getNestedSyncableEntity().orElseThrow(() -> new UnsupportedOperationException("Unable to create a sync message for an empty nested syncable entity")), true);
    }

    public ModSyncableTileMessage(PacketBuffer buffer) {
        super(buffer);
        this._nested = buffer.readBoolean();
        this._payload = buffer.func_150793_b();
    }

    @Override
    protected void processTileEntityMessage(LogicalSide sourceSide, TileEntity tileEntity) {
        ISyncableEntity entity = null;
        if (tileEntity instanceof INestedSyncableEntity && this._nested) {
            entity = ((INestedSyncableEntity)tileEntity).getNestedSyncableEntity().orElse(null);
        } else if (tileEntity instanceof ISyncableEntity) {
            entity = (ISyncableEntity)tileEntity;
        }
        if (null != entity) {
            entity.syncDataFrom(this._payload, ISyncableEntity.SyncReason.NetworkUpdate);
        } else {
            Log.LOGGER.error(Log.NETWORK, "No syncable {}entity found while processing a sync message", (Object)(this._nested ? "(nested) " : ""));
        }
    }

    @Override
    public void encodeTo(PacketBuffer buffer) {
        super.encodeTo(buffer);
        buffer.writeBoolean(this._nested);
        buffer.func_150786_a(this._payload);
    }

    protected ModSyncableTileMessage(BlockPos tileEntityPosition, ISyncableEntity entity, boolean nested) {
        super(tileEntityPosition);
        this._nested = nested;
        this._payload = new CompoundNBT();
        entity.syncDataTo(this._payload, ISyncableEntity.SyncReason.NetworkUpdate);
    }
}

