/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.NBTIngredient;

public abstract class ItemStackRecipeIngredient
implements IRecipeIngredient<ItemStack> {
    public static ItemStackRecipeIngredient from(Ingredient ingredient) {
        return ItemStackRecipeIngredient.from(ingredient, 1);
    }

    public static ItemStackRecipeIngredient from(Ingredient ingredient, int amount) {
        return new Impl(ingredient, amount);
    }

    public static ItemStackRecipeIngredient from(ItemStackRecipeIngredient ... ingredients) {
        return new CompositeImpl(ingredients);
    }

    public static ItemStackRecipeIngredient from(PacketBuffer buffer) {
        int ingredientsCount = buffer.func_150792_a();
        if (1 == ingredientsCount) {
            return new Impl(Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_150792_a());
        }
        if (ingredientsCount > 1) {
            ItemStackRecipeIngredient[] ingredients = new ItemStackRecipeIngredient[ingredientsCount];
            for (int idx = 0; idx < ingredients.length; ++idx) {
                ingredients[idx] = new Impl(Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_150792_a());
            }
            return new CompositeImpl(ingredients);
        }
        throw new IllegalArgumentException("Invalid item ingredient data from then network");
    }

    public static ItemStackRecipeIngredient from(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            JsonArray json = jsonElement.getAsJsonArray();
            int size = json.size();
            switch (size) {
                case 0: {
                    throw new JsonSyntaxException("No ingredients found, at least one is required");
                }
                case 1: {
                    return ItemStackRecipeIngredient.from(json.get(0));
                }
            }
            return ItemStackRecipeIngredient.from((ItemStackRecipeIngredient[])Streams.stream((Iterable)json).map(ItemStackRecipeIngredient::from).toArray(ItemStackRecipeIngredient[]::new));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            Ingredient ingredient = JSONHelper.jsonGetIngredient(json, "ingredient");
            int amount = JSONHelper.jsonGetInt(json, "count", 1);
            if (amount < 1) {
                throw new JsonSyntaxException("Ingredient amount must be larger than or equal to one");
            }
            return new Impl(ingredient, amount);
        }
        throw new JsonSyntaxException("Expected item ingredient entry to be object or array of objects");
    }

    public static ItemStackRecipeIngredient from(ItemStack stack) {
        return ItemStackRecipeIngredient.from(stack, stack.func_190916_E());
    }

    public static ItemStackRecipeIngredient from(ItemStack stack, int amount) {
        return ItemStackRecipeIngredient.from((Ingredient)(stack.func_77942_o() ? new NBTIngredient(stack){} : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack})), amount);
    }

    public static ItemStackRecipeIngredient from(IItemProvider item) {
        return ItemStackRecipeIngredient.from(item, 1);
    }

    public static ItemStackRecipeIngredient from(IItemProvider item, int amount) {
        return ItemStackRecipeIngredient.from(new ItemStack(item), amount);
    }

    public static ItemStackRecipeIngredient from(ITag<Item> tag) {
        return ItemStackRecipeIngredient.from(tag, 1);
    }

    public static ItemStackRecipeIngredient from(ITag<Item> tag, int amount) {
        return ItemStackRecipeIngredient.from(Ingredient.func_199805_a(tag), amount);
    }

    static class CompositeImpl
    extends ItemStackRecipeIngredient {
        private final List<ItemStackRecipeIngredient> _ingredients;
        private List<ItemStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(ItemStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.isCompatible(stack));
        }

        @Override
        public ItemStack getMatchFrom(ItemStack stack) {
            return this._ingredients.stream().map(ingredient -> ingredient.getMatchFrom(stack)).filter(match -> !match.func_190926_b()).findAny().orElse(ItemStack.field_190927_a);
        }

        @Override
        public long getAmount(ItemStack stack) {
            return this._ingredients.stream().mapToLong(ingredient -> ingredient.getAmount(stack)).filter(amount -> amount > 0L).findAny().orElse(0L);
        }

        @Override
        public List<ItemStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = (List)this._ingredients.stream().flatMap(ingredient -> ingredient.getMatchingElements().stream()).collect(ImmutableList.toImmutableList());
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return this._ingredients.stream().anyMatch(IRecipeIngredient::isEmpty);
        }

        @Override
        public List<Ingredient> asVanillaIngredients() {
            return this.getMatchingElements().stream().map(xva$0 -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{xva$0})).collect(Collectors.toList());
        }

        @Override
        public boolean test(ItemStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public void serializeTo(PacketBuffer buffer) {
            buffer.func_150787_b(this._ingredients.size());
            this._ingredients.forEach(ingredient -> ingredient.serializeTo(buffer));
        }

        @Override
        public JsonElement serializeTo() {
            JsonArray json = new JsonArray();
            this._ingredients.forEach(ingredient -> json.add(ingredient.serializeTo()));
            return json;
        }

        public String toString() {
            return this._ingredients.stream().map(Object::toString).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        }

        protected CompositeImpl(ItemStackRecipeIngredient[] ingredients) {
            this._ingredients = Lists.newArrayList((Object[])ingredients);
        }
    }

    static class Impl
    extends ItemStackRecipeIngredient {
        private final Ingredient _ingredient;
        private final int _amount;
        private List<ItemStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(ItemStack stack) {
            return this._ingredient.test(stack);
        }

        @Override
        public ItemStack getMatchFrom(ItemStack stack) {
            return this.test(stack) ? ItemHelper.stackFrom(stack, this._amount) : ItemStack.field_190927_a;
        }

        @Override
        public long getAmount(ItemStack stack) {
            return this.isCompatible(stack) ? (long)this._amount : 0L;
        }

        @Override
        public List<ItemStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = (List)Arrays.stream(this._ingredient.func_193365_a()).filter(stack -> !stack.func_190926_b()).map(stack -> stack.func_190916_E() == this._amount ? stack : ItemHelper.stackFrom(stack, this._amount)).collect(ImmutableList.toImmutableList());
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return this._ingredient.func_203189_d();
        }

        @Override
        public List<Ingredient> asVanillaIngredients() {
            return ObjectLists.singleton((Object)this._ingredient);
        }

        @Override
        public void serializeTo(PacketBuffer buffer) {
            buffer.func_150787_b(1);
            this._ingredient.func_199564_a(buffer);
            buffer.func_150787_b(this._amount);
        }

        @Override
        public JsonElement serializeTo() {
            JsonObject json = new JsonObject();
            JSONHelper.jsonSetIngredient(json, "ingredient", this._ingredient);
            JSONHelper.jsonSetInt(json, "count", this._amount);
            return json;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.isCompatible(stack) && this._amount <= stack.func_190916_E();
        }

        public String toString() {
            return this._amount + " " + Arrays.stream(this._ingredient.func_193365_a()).map(stack -> stack.func_77973_b().toString()).collect(Collectors.joining(","));
        }

        protected Impl(Ingredient ingredient, int amount) {
            this._ingredient = ingredient;
            this._amount = amount;
        }
    }
}

