/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.feature.ModOreFeatureConfig;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.ITag;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.BlockStateMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

abstract class AbstractWorldGenFeaturesMap<PredicateObject> {
    protected final Map<GenerationStage.Decoration, List<Pair<Predicate<PredicateObject>, ConfiguredFeature<?, ?>>>> _entries = Maps.newHashMap();

    public static RuleTest oreMatch(Block block) {
        return new BlockMatchRuleTest(block);
    }

    public static RuleTest oreMatch(ITag<Block> tag) {
        return new TagMatchRuleTest(tag);
    }

    public static RuleTest oreMatch(BlockState state) {
        return new BlockStateMatchRuleTest(state);
    }

    public void addOre(Predicate<PredicateObject> biomeMatcher, ConfiguredFeature<?, ?> configSupplier) {
        this.add(GenerationStage.Decoration.UNDERGROUND_ORES, biomeMatcher, configSupplier);
    }

    protected AbstractWorldGenFeaturesMap() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, EventPriority.HIGHEST, this::clearItems);
    }

    protected void add(GenerationStage.Decoration stage, Predicate<PredicateObject> biomeMatcher, ConfiguredFeature<?, ?> configSupplier) {
        this._entries.computeIfAbsent(stage, s -> Lists.newLinkedList()).add(Pair.of(biomeMatcher, configSupplier));
    }

    protected static ConfiguredFeature<?, ?> oreFeature(Supplier<Feature<ModOreFeatureConfig>> oreFeature, Supplier<ModBlock> oreBlock, RuleTest matchRule, int clustersAmount, int oresPerCluster, int placementBottomOffset, int placementTopOffset, int placementMaximum) {
        return oreFeature.get().func_225566_b_((IFeatureConfig)new ModOreFeatureConfig(matchRule, oreBlock.get().func_176223_P(), oresPerCluster)).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(placementBottomOffset, placementTopOffset, placementMaximum)).func_242728_a()).func_242731_b(clustersAmount));
    }

    public void clearItems(RegistryEvent.Register<Feature<?>> event) {
        this._entries.clear();
    }
}

