/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="zerocore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChunkCache {
    private static final Map<IWorld, ChunkCache> s_caches = new Reference2ObjectArrayMap(16);
    private final Long2ObjectMap<Chunk> _chunks;
    private final World _world;

    @Nullable
    public static ChunkCache get(World world) {
        return s_caches.get(world);
    }

    public static ChunkCache getOrCreate(World world) {
        return s_caches.computeIfAbsent((IWorld)world, w -> new ChunkCache(Objects.requireNonNull(world)));
    }

    @Nullable
    public Chunk get(BlockPos position) {
        int chunkZ;
        if (!World.func_175701_a((BlockPos)position)) {
            return null;
        }
        int chunkX = position.func_177958_n() >> 4;
        long chunkHash = ChunkPos.func_77272_a((int)chunkX, (int)(chunkZ = position.func_177952_p() >> 4));
        Chunk chunk = (Chunk)this._chunks.get(chunkHash);
        if (null == chunk && null != (chunk = (Chunk)this._world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false))) {
            this._chunks.put(chunkHash, (Object)chunk);
        }
        return chunk;
    }

    public void remove(Chunk chunk) {
        this._chunks.remove(chunk.func_76632_l().func_201841_a());
    }

    public void clear() {
        this._chunks.clear();
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCache cache;
        IChunk chunk = Objects.requireNonNull(event.getChunk());
        IWorld world = chunk.getWorldForge();
        if (null != world && null != (cache = s_caches.get(world))) {
            cache.remove((Chunk)chunk);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        IWorld world = Objects.requireNonNull(event.getWorld());
        ChunkCache cache = s_caches.get(world);
        if (null != cache) {
            cache.clear();
            s_caches.remove(world);
        }
    }

    private ChunkCache(World world) {
        this._world = Objects.requireNonNull(world);
        this._chunks = new Long2ObjectOpenHashMap(2048, 0.75f);
    }
}

