/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.stream.LongStream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class NeighboringPositions {
    private final Direction[] _directions;
    private final BlockPos.Mutable[] _neighbors;
    private final long[] _neighborHashes;

    public NeighboringPositions() {
        this(0, 0, 0, CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(Direction[] directions) {
        this(0, 0, 0, directions);
    }

    public NeighboringPositions(BlockPos position) {
        this(position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(BlockPos position, Direction[] directions) {
        this(position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), directions);
    }

    public NeighboringPositions(int x, int y, int z) {
        this(x, y, z, CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(int x, int y, int z, Direction[] directions) {
        int length = directions.length;
        this._directions = directions;
        this._neighbors = new BlockPos.Mutable[length];
        this._neighborHashes = new long[length];
        for (int i = 0; i < length; ++i) {
            BlockPos.Mutable position;
            this._neighbors[i] = position = new BlockPos.Mutable(x, y, z).func_189536_c(this._directions[i]);
            this._neighborHashes[i] = position.func_218275_a();
        }
    }

    public void setTo(BlockPos position) {
        this.setTo(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    public void setTo(int x, int y, int z) {
        for (int i = 0; i < this._neighbors.length; ++i) {
            BlockPos.Mutable position = this._neighbors[i].func_181079_c(x, y, z).func_189534_c(this._directions[i], 1);
            this._neighborHashes[i] = position.func_218275_a();
        }
    }

    public int size() {
        return this._neighbors.length;
    }

    public BlockPos get(int index) {
        return this._neighbors[index];
    }

    public long getHash(int index) {
        return this._neighborHashes[index];
    }

    public LongStream getHashStream() {
        return LongStream.of(this._neighborHashes);
    }
}

