/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientStack
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    public static final IngredientStack EMPTY = new IngredientStack(Stream.empty(), 0);
    private final int count;

    protected IngredientStack(Stream<? extends Ingredient.IItemList> itemLists, int count) {
        super(itemLists);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.func_199806_d();
        if (this.field_193371_b.length == 0) {
            return stack.func_190926_b();
        }
        for (ItemStack itemstack : this.field_193371_b) {
            if (itemstack.func_77973_b() != stack.func_77973_b() || stack.func_190916_E() < this.count) continue;
            return true;
        }
        return false;
    }

    public boolean itemTest(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.func_199806_d();
        if (this.field_193371_b.length == 0) {
            return stack.func_190926_b();
        }
        for (ItemStack itemstack : this.field_193371_b) {
            if (itemstack.func_77973_b() != stack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    protected void func_199806_d() {
        if (this.field_193371_b == null) {
            this.field_193371_b = (ItemStack[])Arrays.stream(this.field_199807_b).flatMap(itemList -> itemList.func_199799_a().stream()).peek(stack -> stack.func_190920_e(this.count)).distinct().toArray(ItemStack[]::new);
        }
    }

    public IIngredientSerializer<? extends IngredientStack> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement func_200304_c() {
        JsonObject obj = new JsonObject();
        obj.addProperty("count", (Number)this.count);
        JsonArray jsonarray = new JsonArray();
        for (Ingredient.IItemList ingredient$iitemlist : this.field_199807_b) {
            jsonarray.add((JsonElement)ingredient$iitemlist.func_200303_b());
        }
        obj.add("items", (JsonElement)jsonarray);
        obj.addProperty("type", DraconicAPI.INGREDIENT_STACK_TYPE.toString());
        return obj;
    }

    public static IngredientStack fromItemListStream(Stream<? extends Ingredient.IItemList> stream, int count) {
        IngredientStack ingredient = new IngredientStack(stream, count);
        return ingredient.field_199807_b.length == 0 ? EMPTY : ingredient;
    }

    public static IngredientStack fromItems(int count, IItemProvider ... itemsIn) {
        return IngredientStack.fromStacks(Arrays.stream(itemsIn).map(ItemStack::new), count);
    }

    public static IngredientStack fromStacks(int count, ItemStack ... stacks) {
        return IngredientStack.fromStacks(Arrays.stream(stacks), count);
    }

    public static IngredientStack fromStacks(Stream<ItemStack> stacks, int count) {
        return IngredientStack.fromItemListStream(stacks.filter(stack -> !stack.func_190926_b()).map(Ingredient.SingleItemList::new), count);
    }

    public static IngredientStack fromTag(ITag<Item> tagIn, int count) {
        return IngredientStack.fromItemListStream(Stream.of(new Ingredient.TagList(tagIn)), count);
    }

    public static class Serializer
    implements IIngredientSerializer<IngredientStack> {
        public IngredientStack parse(PacketBuffer buffer) {
            short count = buffer.readShort();
            return IngredientStack.fromItemListStream(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()), count);
        }

        public IngredientStack parse(JsonObject json) {
            short count = json.get("count").getAsShort();
            JsonArray stacks = json.get("items").getAsJsonArray();
            return IngredientStack.fromItemListStream(Streams.stream((Iterable)stacks).map(e -> Ingredient.func_199803_a((JsonObject)e.getAsJsonObject())), count);
        }

        public void write(PacketBuffer buffer, IngredientStack ingredient) {
            buffer.writeShort(ingredient.getCount());
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

