/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class UndyingData
implements ModuleData<UndyingData> {
    private final float healthBoost;
    private final float shieldBoost;
    private final int shieldBoostTime;
    private final int chargeTime;
    private final long chargeEnergy;
    private final int invulnerableTime;

    public UndyingData(float healthBoost, float shieldBoost, int shieldBoostTime, int chargeTime, long chargeEnergy, int invulnerableTime) {
        this.healthBoost = healthBoost;
        this.shieldBoost = shieldBoost;
        this.shieldBoostTime = shieldBoostTime;
        this.chargeTime = chargeTime;
        this.chargeEnergy = chargeEnergy;
        this.invulnerableTime = invulnerableTime;
    }

    public float getHealthBoost() {
        return this.healthBoost;
    }

    public float getShieldBoost() {
        return this.shieldBoost;
    }

    public int getShieldBoostTime() {
        return this.shieldBoostTime;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public long getChargeEnergyRate() {
        return this.chargeEnergy / (long)this.chargeTime;
    }

    public long getChargeEnergy() {
        return this.chargeEnergy;
    }

    public int getInvulnerableTime() {
        return this.invulnerableTime;
    }

    @Override
    public UndyingData combine(UndyingData other) {
        return other;
    }

    @Override
    public void addInformation(Map<ITextComponent, ITextComponent> map, ModuleContext context, boolean stack) {
        if (stack) {
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.health.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.health.value", new Object[]{(int)this.healthBoost}));
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.shield.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.shield.value", new Object[]{(int)this.shieldBoost, this.shieldBoostTime / 20}));
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.charge.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.charge.value", new Object[]{this.chargeTime / 20}));
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.energy.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.energy.value", new Object[]{ModuleData.formatNumber(this.chargeEnergy), this.getChargeEnergyRate()}));
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.invuln.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.undying.invuln.value", new Object[]{this.invulnerableTime / 20}));
        }
    }
}

