/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;

public class FlightEntity
extends ModuleEntity {
    private BooleanProperty elytraEnabled = null;
    private BooleanProperty creativeEnabled = null;
    private DecimalProperty elytraBoost = null;
    public static UUID FLIGHT_UUID = UUID.fromString("415af318-505f-4fa2-a2d8-c432373dc600");
    private static AttributeModifier FLIGHT_MODIFIER = new AttributeModifier(FLIGHT_UUID, "Flight Module", 1.0, AttributeModifier.Operation.ADDITION);
    public static UUID FLIGHT_SPEED_UUID = UUID.fromString("d5775a32-4480-4f1f-b247-3942be930464");
    private static AttributeModifier SPEED_MODIFIER = new AttributeModifier(FLIGHT_SPEED_UUID, "Flight Speed Enchantment", 1.0, AttributeModifier.Operation.ADDITION);

    public FlightEntity(Module<FlightData> module) {
        super(module);
        if (module.getData().elytra()) {
            this.elytraEnabled = new BooleanProperty("flight_mod.elytra", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
            this.addProperty(this.elytraEnabled);
            this.elytraBoost = new DecimalProperty("flight_mod.elytra_boost", module.getData().getElytraSpeed()).setFormatter(ConfigProperty.DecimalFormatter.PERCENT_0).range(0.0, module.getData().getElytraSpeed());
            this.addProperty(this.elytraBoost);
        }
        if (module.getData().creative()) {
            this.creativeEnabled = new BooleanProperty("flight_mod.creative", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
            this.addProperty(this.creativeEnabled);
        }
        this.savePropertiesToItem = true;
    }

    @Override
    public void onInstalled(ModuleContext context) {
    }

    public boolean getElytraEnabled() {
        return this.elytraEnabled != null && this.elytraEnabled.getValue();
    }

    public boolean getCreativeEnabled() {
        return this.creativeEnabled != null && this.creativeEnabled.getValue();
    }

    public double getElytraBoost() {
        return this.elytraBoost != null ? this.elytraBoost.getValue() : 0.0;
    }
}

