/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClient;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServer;
import com.brandon3055.draconicevolution.blocks.tileentity.PortalHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDislocatorReceptacle
extends TileBCore
implements ITickableTileEntity,
IInteractTile,
IHudBlock,
IRSSwitchable,
DislocatorEndPoint,
ICrystalLink,
IENetEffectTile {
    public final ManagedPos arrivalPos = (ManagedPos)this.register((IManagedData)new ManagedPos("arrival_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte ignitionStage = (ManagedByte)this.register((IManagedData)new ManagedByte("ignition_stage", 0, new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedEnum<Direction.Axis> activeAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("active_axis", (Enum)Direction.Axis.X, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedPos linkedCrystal = (ManagedPos)this.register((IManagedData)new ManagedPos("crystal_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte remoteCrystalTier = (ManagedByte)this.register((IManagedData)new ManagedByte("crystal_pos_tier", 0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte linkedFlowRate = (ManagedByte)this.register((IManagedData)new ManagedByte("linked_flow_rate", 0, new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedPos crystalLinkPos = (ManagedPos)this.register((IManagedData)new ManagedPos("crystal_link_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(1);
    private PortalHelper portalHelper = new PortalHelper(this);
    private List<Entity> teleportQ = new ArrayList<Entity>();
    private BlockPos remotePosCache = null;
    private RegistryKey<World> remoteWorldCache = null;
    private int invalidLinkTime = 0;
    protected ENetFXHandler fxHandler;
    boolean hashCached = false;
    int hashID = 0;

    public TileDislocatorReceptacle() {
        super(DEContent.tile_dislocator_receptacle);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setContentsChangeListener(e -> this.onInventoryChange());
        this.itemHandler.setSlotValidator(0, stack -> stack.func_77973_b() instanceof Dislocator);
        this.fxHandler = DraconicEvolution.proxy.createENetFXHandler(this);
    }

    public void onSignalChange(boolean newSignal) {
        if (newSignal) {
            this.attemptActivation();
        } else {
            this.deactivate();
        }
    }

    public ActionResultType onBlockUse(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasRSSignal()) {
            return ActionResultType.PASS;
        }
        if (stack.func_77973_b() == DEContent.infused_obsidian.func_199767_j()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)DislocatorReceptacle.CAMO) == false)));
            return ActionResultType.SUCCESS;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack previousInstalled = this.itemHandler.getStackInSlot(0);
            InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (PlayerEntity)player);
            if (BoundDislocator.isValid(previousInstalled) && BoundDislocator.isP2P(previousInstalled) && this.itemHandler.getStackInSlot(0).func_190926_b()) {
                DislocatorSaveData.updateLinkTarget(this.field_145850_b, previousInstalled, new PlayerTarget(player));
            }
            this.checkIn();
        }
        return ActionResultType.SUCCESS;
    }

    private void onInventoryChange() {
        ItemStack stack;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.portalHelper.isRunning()) {
            this.portalHelper.abort();
        }
        if ((stack = this.itemHandler.getStackInSlot(0)).func_190926_b() && this.isActive()) {
            this.deactivate();
        } else if (!stack.func_190926_b()) {
            this.attemptActivation();
        }
    }

    public void attemptActivation() {
        if (this.field_145850_b.field_72995_K || this.isActive() || this.portalHelper.isRunning()) {
            return;
        }
        TargetPos target = this.getTargetPos();
        if (target != null) {
            this.portalHelper.startScan();
            this.ignitionStage.set(1);
        }
    }

    public void deactivate() {
        this.setActive(false);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.func_174877_v().func_177982_a(-1, -1, -1), (BlockPos)this.func_174877_v().func_177982_a(1, 1, 1))) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (!(tile instanceof TilePortal) || !((TilePortal)tile).getControllerPos().equals((Object)this.func_174877_v())) continue;
            this.field_145850_b.func_217377_a(pos, false);
        }
    }

    public void handleEntityTeleport(Entity entity) {
        if (this.field_145850_b.field_72995_K || this.teleportQ.contains(entity)) {
            return;
        }
        if (entity.func_242280_ah()) {
            entity.func_242279_ag();
            return;
        }
        this.teleportQ.add(entity);
    }

    public void func_73660_a() {
        this.updateCrystalLogic();
        super.tick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.portalHelper.isRunning()) {
            int maxSpeed = this.portalHelper.isBuilding() ? 125 : 384;
            int cycles = Utils.scaleToTPS((World)this.field_145850_b, (int)(maxSpeed / 8), (int)maxSpeed);
            for (int i = 0; i < cycles && this.portalHelper.isRunning(); ++i) {
                this.portalHelper.updateTick();
            }
        } else if (!this.teleportQ.isEmpty()) {
            for (Entity entity : this.teleportQ) {
                TargetPos target = this.getTargetPos();
                if (target == null) {
                    this.deactivate();
                    this.teleportQ.clear();
                    return;
                }
                BCoreNetwork.sendSound((World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
                entity.func_242279_ag();
                target.teleport(entity);
                if (entity instanceof ServerPlayerEntity) {
                    DelayedTask.run((int)10, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayerEntity)entity));
                    DelayedTask.run((int)20, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayerEntity)entity));
                    DelayedTask.run((int)60, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayerEntity)entity));
                }
                entity.func_242279_ag();
                BCoreNetwork.sendSound((World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
            }
            this.teleportQ.clear();
        }
    }

    public void onScanBlock(BlockPos pos) {
    }

    public void onScanComplete(@Nullable Set<BlockPos> result, @Nullable Direction.Axis resultAxis) {
        if (result == null || resultAxis == null) {
            this.ignitionStage.set(0);
        } else {
            this.ignitionStage.set(2);
            this.portalHelper.buildPortal(result, resultAxis);
            this.activeAxis.set((Enum)resultAxis);
        }
    }

    public void onBuildSuccess(List<BlockPos> builtList) {
        this.setActive(true);
        this.ignitionStage.set(0);
        HashMap levelMap = new HashMap();
        builtList.forEach(block -> levelMap.computeIfAbsent(block.func_177956_o(), integer -> new ArrayList()).add(block));
        LinkedList levels = new LinkedList(levelMap.keySet());
        levels.sort(Comparator.naturalOrder());
        ArrayList<BlockPos> foundValid = new ArrayList<BlockPos>();
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            List blocks = (List)levelMap.get(level);
            Iterator iterator2 = blocks.iterator();
            while (iterator2.hasNext()) {
                BlockPos pos = (BlockPos)iterator2.next();
                if (!this.field_145850_b.func_175623_d(pos.func_177984_a()) && this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() != DEContent.portal) continue;
                foundValid.add(pos);
            }
            if (foundValid.isEmpty()) continue;
            break;
        }
        if (foundValid.isEmpty()) {
            this.arrivalPos.set(null);
            return;
        }
        Vector3 min = new Vector3().set(6.0E7);
        Vector3 max = new Vector3().set(-6.0E7);
        for (BlockPos pos : foundValid) {
            if ((double)pos.func_177958_n() < min.x) {
                min.x = pos.func_177958_n();
            }
            if ((double)pos.func_177956_o() < min.y) {
                min.y = pos.func_177956_o();
            }
            if ((double)pos.func_177952_p() < min.z) {
                min.z = pos.func_177952_p();
            }
            if ((double)pos.func_177958_n() > max.x) {
                max.x = pos.func_177958_n();
            }
            if ((double)pos.func_177956_o() > max.y) {
                max.y = pos.func_177956_o();
            }
            if (!((double)pos.func_177952_p() > max.z)) continue;
            max.z = pos.func_177952_p();
        }
        Vector3 mid = min.copy().add(max.subtract(min).divide(2.0));
        BlockPos closestPos = (BlockPos)foundValid.get(0);
        double closest = 2.147483647E9;
        for (BlockPos pos : foundValid) {
            double dist = Utils.getDistanceSq((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (double)mid.x, (double)mid.y, (double)mid.z);
            if (!(dist < closest)) continue;
            closest = dist;
            closestPos = pos;
        }
        this.arrivalPos.set(closestPos);
        this.setLinkPos(this.getMidPos(builtList));
    }

    private BlockPos getMidPos(List<BlockPos> blocks) {
        Vector3 min = new Vector3(6.0E7, 6.0E7, 6.0E7);
        Vector3 max = new Vector3(-6.0E7, -6.0E7, -6.0E7);
        for (BlockPos pos2 : blocks) {
            if ((double)pos2.func_177958_n() + 0.5 < min.x) {
                min.x = (double)pos2.func_177958_n() + 0.5;
            }
            if ((double)pos2.func_177956_o() + 0.5 < min.y) {
                min.y = (double)pos2.func_177956_o() + 0.5;
            }
            if ((double)pos2.func_177952_p() + 0.5 < min.z) {
                min.z = (double)pos2.func_177952_p() + 0.5;
            }
            if ((double)pos2.func_177958_n() + 0.5 > max.x) {
                max.x = (double)pos2.func_177958_n() + 0.5;
            }
            if ((double)pos2.func_177956_o() + 0.5 > max.y) {
                max.y = (double)pos2.func_177956_o() + 0.5;
            }
            if (!((double)pos2.func_177952_p() + 0.5 > max.z)) continue;
            max.z = (double)pos2.func_177952_p() + 0.5;
        }
        Vector3 mid = min.copy().add(max.subtract(min).divide(2.0));
        return blocks.stream().min(Comparator.comparingDouble(pos -> MathUtils.distanceSq((Vector3)mid, (Vector3)Vector3.fromBlockPosCenter((BlockPos)pos)))).orElse(null);
    }

    public void onBuildFail() {
        this.setActive(false);
        this.ignitionStage.set(0);
    }

    public boolean isActive() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)DislocatorReceptacle.ACTIVE);
    }

    public void setActive(boolean active) {
        if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == DEContent.dislocator_receptacle) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    private TargetPos getTargetPos() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!(stack.func_77973_b() instanceof Dislocator)) {
            return null;
        }
        return ((Dislocator)stack.func_77973_b()).getTargetPos(stack, this.field_145850_b);
    }

    public void generateHudText(World world, BlockPos pos, PlayerEntity player, List<ITextComponent> displayList) {
        displayList.add((ITextComponent)new StringTextComponent(this.ignitionStage.get() == 1 ? "Scanning..." : "Activating..."));
    }

    public boolean shouldDisplayHudText(World world, BlockPos pos, PlayerEntity player) {
        return this.ignitionStage.get() > 0;
    }

    public void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack)) {
            DislocatorSaveData.updateLinkTarget(this.field_145850_b, stack, new TileTarget(this));
        }
    }

    private boolean isBound() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack);
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b instanceof ServerWorld) {
            this.checkIn();
        }
    }

    @Override
    @Nullable
    public Vector3d getArrivalPos(UUID linkID) {
        BlockPos ap = this.arrivalPos.get();
        return this.isActive() && ap != null ? new Vector3d((double)ap.func_177958_n() + 0.5, (double)ap.func_177956_o() + 0.25, (double)ap.func_177952_p()) : null;
    }

    @Override
    public void entityArriving(Entity entity) {
        entity.func_242279_ag();
        if (entity instanceof ServerPlayerEntity) {
            DelayedTask.run((int)10, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayerEntity)entity));
            DelayedTask.run((int)20, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayerEntity)entity));
            DelayedTask.run((int)60, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayerEntity)entity));
        }
    }

    private void updateCrystalLogic() {
        boolean boundCrystals;
        this.fxHandler.update();
        boolean bl = boundCrystals = this.isActive() && this.isBound() && this.linkedCrystal.get() != null;
        if (this.field_145850_b.field_72995_K && boundCrystals && this.remoteCrystalTier.isDirty(false)) {
            this.fxHandler.reloadConnections();
        }
        if (!this.field_145850_b.field_72995_K && boundCrystals) {
            if (DEEventHandler.serverTicks % 10 == 0) {
                TileDislocatorReceptacle remoteTile = this.getRemoteReceptacle();
                ICrystalLink remote = this.getRemoteCrystal();
                if (remoteTile != null && remote instanceof IENetEffectTile) {
                    int i = remote.getLinks().indexOf(remoteTile.func_174877_v());
                    LinkedList<Byte> rates = ((IENetEffectTile)remote).getFlowRates();
                    if (i >= 0 && i < rates.size()) {
                        this.linkedFlowRate.set((int)((Byte)rates.get(i)).byteValue());
                    } else {
                        this.linkedFlowRate.set(0);
                    }
                } else {
                    this.linkedFlowRate.set(0);
                }
            }
            if (this.linkedFlowRate.get() != 0 && DEEventHandler.serverTicks % 100 == 0) {
                this.dataManager.forceSync((IManagedData)this.linkedFlowRate);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            this.linkedFlowRate.set(0);
        }
    }

    public void setLinkPos(BlockPos spawnPos) {
        this.crystalLinkPos.set(this.func_174877_v().func_177973_b((Vector3i)spawnPos));
    }

    protected BlockPos getLinkPos() {
        if (this.crystalLinkPos.get() != null) {
            return this.func_174877_v().func_177973_b((Vector3i)Objects.requireNonNull(this.crystalLinkPos.get()));
        }
        return BlockPos.field_177992_a;
    }

    protected void setCrystalPos(BlockPos crystalPos) {
        this.linkedCrystal.set(this.func_174877_v().func_177973_b((Vector3i)crystalPos));
    }

    protected BlockPos getCrystalPos() {
        if (this.linkedCrystal.get() != null) {
            return this.func_174877_v().func_177973_b((Vector3i)Objects.requireNonNull(this.linkedCrystal.get()));
        }
        return BlockPos.field_177992_a;
    }

    private TileDislocatorReceptacle getRemoteReceptacle() {
        return this.getRemoteReceptacle(false);
    }

    private TileDislocatorReceptacle getRemoteReceptacle(boolean skipRemoteCheck) {
        MinecraftServer server;
        if (!this.isActive() || !this.isBound()) {
            return null;
        }
        if (this.invalidLinkTime > 0) {
            --this.invalidLinkTime;
            return null;
        }
        if (this.remotePosCache == null) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            DislocatorTarget target = DislocatorSaveData.getLinkTarget(this.field_145850_b, stack);
            if (target instanceof TileTarget) {
                TileTarget tileTarget = (TileTarget)target;
                this.remotePosCache = tileTarget.getTilePos();
                this.remoteWorldCache = tileTarget.getWorldKey();
            } else {
                this.invalidLinkTime = 100;
                return null;
            }
        }
        if ((server = this.field_145850_b.func_73046_m()) != null) {
            TileEntity tile;
            ServerWorld remoteWorld = server.func_71218_a(this.remoteWorldCache);
            if (remoteWorld != null && (tile = remoteWorld.func_175625_s(this.remotePosCache)) instanceof TileDislocatorReceptacle) {
                if (skipRemoteCheck) {
                    return (TileDislocatorReceptacle)tile;
                }
                if (((TileDislocatorReceptacle)tile).isActive() && ((TileDislocatorReceptacle)tile).getRemoteReceptacle(true) == this) {
                    return (TileDislocatorReceptacle)tile;
                }
            }
            this.remotePosCache = null;
            return null;
        }
        return null;
    }

    private ICrystalLink getRemoteCrystal() {
        MinecraftServer server;
        TileDislocatorReceptacle tile = this.getRemoteReceptacle();
        if (tile != null && (server = this.field_145850_b.func_73046_m()) != null && tile.linkedCrystal.get() != null) {
            TileEntity crystal;
            ServerWorld remoteWorld = server.func_71218_a(this.remoteWorldCache);
            if (remoteWorld != null && (crystal = remoteWorld.func_175625_s(tile.getCrystalPos())) instanceof IENetEffectTile) {
                this.remoteCrystalTier.set(((IENetEffectTile)crystal).getTier());
                return (ICrystalLink)crystal;
            }
            return null;
        }
        return null;
    }

    @Override
    @Nonnull
    public List<BlockPos> getLinks() {
        if (this.linkedCrystal.get() != null) {
            return Collections.singletonList(this.getCrystalPos());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean binderUsed(PlayerEntity player, BlockPos linkTarget, Direction sideClicked) {
        return false;
    }

    @Override
    public boolean createLink(ICrystalLink otherCrystal) {
        this.setCrystalPos(((TileEntity)otherCrystal).func_174877_v());
        return true;
    }

    @Override
    public void breakLink(BlockPos otherCrystal) {
        this.linkedCrystal.set(null);
    }

    @Override
    public int balanceMode() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.balanceMode() : 1;
    }

    @Override
    public int maxLinks() {
        return 1;
    }

    @Override
    public int maxLinkRange() {
        return 32;
    }

    @Override
    public long getEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getEnergyStored() : 0L;
    }

    @Override
    public long getMaxEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getMaxEnergyStored() : 0L;
    }

    @Override
    public void modifyEnergyStored(long energy) {
        ICrystalLink remote = this.getRemoteCrystal();
        if (remote != null) {
            remote.modifyEnergyStored(energy);
        }
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        double dist = FacingUtils.distanceInDirection((BlockPos)this.func_174877_v(), (BlockPos)linkTo, (Direction)FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[0]);
        Vec3D vec = Vec3D.getCenter((BlockPos)this.getLinkPos());
        Direction facing = dist > 0.0 ? FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[0] : FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[1];
        vec.add((double)facing.func_82601_c() * 0.35, (double)facing.func_96559_d() * 0.35, (double)facing.func_82599_e() * 0.35);
        return vec;
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServer<TileDislocatorReceptacle>(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClient<TileDislocatorReceptacle>(this);
    }

    @Override
    public boolean hasStaticFX() {
        return false;
    }

    @Override
    public CrystalFXBase<?> createStaticFX() {
        return null;
    }

    @Override
    public LinkedList<Byte> getFlowRates() {
        return new LinkedList<Byte>(Collections.singletonList((byte)this.linkedFlowRate.get()));
    }

    @Override
    public int getTier() {
        return this.remoteCrystalTier.get();
    }

    @Override
    public int getIDHash() {
        if (!this.hashCached) {
            this.hashID = this.func_174877_v().hashCode();
            this.hashCached = true;
        }
        return this.hashID;
    }
}

