/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IExtendedRFStorage;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.machines.EnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCoreStructure;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEnergyPylon
extends TileBCore
implements ITickableTileEntity,
IMultiBlockPart,
IExtendedRFStorage {
    public final ManagedBool isOutputMode = (ManagedBool)this.register((IManagedData)new ManagedBool("is_output_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool structureValid = (ManagedBool)this.register((IManagedData)new ManagedBool("structure_valid", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedVec3I coreOffset = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("core_offset", new Vec3I(0, -1, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool sphereOnTop = (ManagedBool)this.register((IManagedData)new ManagedBool("sphere_on_top", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool hasCoreLock = (ManagedBool)this.register((IManagedData)new ManagedBool("has_core_lock", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedByte particleRate = (ManagedByte)this.register((IManagedData)new ManagedByte("particle_rate", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private TileEnergyCore core = null;
    private int coreSelection = 0;
    private int tick = 0;
    private int lastCompOverride = 0;
    private IOPStorage opAdapter = new IOPStorage(){

        public boolean canExtract() {
            return TileEnergyPylon.this.getExtendedStorage() > 0L;
        }

        public boolean canReceive() {
            return TileEnergyPylon.this.getExtendedStorage() < TileEnergyPylon.this.getExtendedCapacity();
        }

        public long receiveOP(long maxReceive, boolean simulate) {
            if (!TileEnergyPylon.this.hasCoreLock.get() || TileEnergyPylon.this.isOutputMode.get() || TileEnergyPylon.this.getCore() == null || !TileEnergyPylon.this.getCore().active.get()) {
                return 0L;
            }
            long received = TileEnergyPylon.this.getCore().receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0L) {
                TileEnergyPylon.this.particleRate.set((int)((byte)Math.min(20L, received < 500L ? 1L : received / 500L)));
            }
            return received;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            if (!(TileEnergyPylon.this.hasCoreLock.get() && TileEnergyPylon.this.isOutputMode.get() && TileEnergyPylon.this.getCore() != null && TileEnergyPylon.this.getCore().active.get())) {
                return 0L;
            }
            long extracted = TileEnergyPylon.this.getCore().extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0L) {
                TileEnergyPylon.this.particleRate.set((int)((byte)Math.min(20L, extracted < 500L && extracted > 0L ? 1L : extracted / 500L)));
            }
            return extracted;
        }

        public long getOPStored() {
            return TileEnergyPylon.this.getExtendedStorage();
        }

        public long getMaxOPStored() {
            return TileEnergyPylon.this.getExtendedCapacity();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.receiveOP(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return (int)Math.min(this.getOPStored(), Integer.MAX_VALUE);
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(this.getMaxOPStored(), Integer.MAX_VALUE);
        }
    };

    public TileEnergyPylon() {
        super(DEContent.tile_energy_pylon);
        this.capManager.set(CapabilityOP.OP, (Object)this.opAdapter, new Direction[0]);
    }

    public void func_73660_a() {
        long extracted;
        super.tick();
        if (!(this.structureValid.get() && this.hasCoreLock.get() && this.getCore() != null && this.getCore().active.get())) {
            return;
        }
        if (this.tick++ % 10 == 0 && this.getExtendedCapacity() > 0L) {
            this.updateComparators();
        }
        if (!this.field_145850_b.field_72995_K && this.isOutputMode.get() && (extracted = this.getCore().extractEnergy(this.sendEnergyToAll(this.opAdapter.getOPStored(), this.opAdapter.getOPStored()), false)) > 0L) {
            this.particleRate.set((int)((byte)Math.min(20L, extracted < 500L ? 1L : extracted / 500L)));
        }
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
        }
        if (!this.field_145850_b.field_72995_K && (this.particleRate.get() > 1 || this.particleRate.get() > 0 && this.field_145850_b.field_73012_v.nextInt(2) == 0)) {
            this.particleRate.subtract(2);
        }
    }

    public void updateComparators() {
        int cOut = (int)((double)this.getExtendedStorage() / (double)this.getExtendedCapacity() * 15.0);
        if (cOut != this.lastCompOverride) {
            this.lastCompOverride = cOut;
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    public void invertIO() {
        this.isOutputMode.invert();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyPylon.OUTPUT, (Comparable)Boolean.valueOf(this.isOutputMode.get())));
    }

    public TileEnergyCore getCore() {
        if (this.hasCoreLock.get()) {
            BlockPos corePos = this.field_174879_c.func_177973_b((Vector3i)this.coreOffset.get().getPos());
            Chunk coreChunk = this.field_145850_b.func_175726_f(corePos);
            if (!this.field_145850_b.isAreaLoaded(corePos, 16)) {
                this.core = null;
                return null;
            }
            TileEntity tileAtPos = coreChunk.func_177424_a(corePos, Chunk.CreateEntityType.CHECK);
            if (tileAtPos == null || this.core == null || tileAtPos != this.core) {
                TileEntity tile = this.field_145850_b.func_175625_s(corePos);
                if (tile instanceof TileEnergyCore) {
                    this.core = (TileEnergyCore)tile;
                } else {
                    this.core = null;
                    this.hasCoreLock.set(false);
                }
            }
        }
        return this.core;
    }

    private List<TileEnergyCore> findActiveCores() {
        LinkedList<TileEnergyCore> list = new LinkedList<TileEnergyCore>();
        int yMod = this.sphereOnTop.get() ? 18 : -18;
        int range = 18;
        Iterable positions = BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-range, -range + yMod, -range), (BlockPos)this.field_174879_c.func_177982_a(range, range + yMod, range));
        for (BlockPos blockPos : positions) {
            TileEntity tile;
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != DEContent.energy_core || !((tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEnergyCore) || !((TileEnergyCore)tile).active.get()) continue;
            list.add((TileEnergyCore)tile);
        }
        return list;
    }

    public void selectNextCore() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<TileEnergyCore> cores = this.findActiveCores();
        if (cores.size() == 0) {
            this.core = null;
            this.hasCoreLock.set(false);
            return;
        }
        if (this.coreSelection >= cores.size()) {
            this.coreSelection = 0;
        }
        TileEnergyCore selectedCore = cores.get(this.coreSelection);
        this.coreOffset.set(new Vec3I(this.field_174879_c.func_177973_b((Vector3i)selectedCore.func_174877_v())));
        this.core = selectedCore;
        this.hasCoreLock.set(true);
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        ++this.coreSelection;
        if (this.hasCoreLock.get()) {
            this.drawParticleBeam();
        }
        this.updateBlock();
    }

    @Override
    public boolean validateStructure() {
        if (!this.structureValid.get()) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, 0)).func_177230_c() == Blocks.field_150359_w) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, 1, 0), DEContent.energy_core_structure.func_176223_P());
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
                if (tile instanceof TileCoreStructure) {
                    ((TileCoreStructure)tile).blockName.set("minecraft:glass");
                    ((TileCoreStructure)tile).setController(this);
                }
                this.sphereOnTop.set(true);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyPylon.FACING, (Comparable)((Object)"up")));
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150359_w) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, -1, 0), DEContent.energy_core_structure.func_176223_P());
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
                if (tile instanceof TileCoreStructure) {
                    ((TileCoreStructure)tile).blockName.set("minecraft:glass");
                    ((TileCoreStructure)tile).setController(this);
                }
                this.sphereOnTop.set(false);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyPylon.FACING, (Comparable)((Object)"down")));
            } else {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyPylon.FACING, (Comparable)((Object)"null")));
                return false;
            }
        }
        this.structureValid.set(this.isStructureValid());
        if (this.structureValid.get() && !this.hasCoreLock.get()) {
            this.selectNextCore();
        } else if (!this.structureValid.get() && this.hasCoreLock.get()) {
            this.hasCoreLock.set(false);
        }
        if (this.hasCoreLock.get() && this.field_145850_b.field_72995_K) {
            this.drawParticleBeam();
        }
        return this.structureValid.get();
    }

    @Override
    public boolean isStructureValid() {
        return !(!this.isGlass(this.field_174879_c.func_177982_a(0, 1, 0)) && !this.isGlass(this.field_174879_c.func_177982_a(0, -1, 0)) || this.isGlass(this.field_174879_c.func_177982_a(0, 1, 0)) && this.isGlass(this.field_174879_c.func_177982_a(0, -1, 0)));
    }

    private boolean isGlass(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        return tile instanceof TileCoreStructure && ((TileCoreStructure)tile).blockName.get().equals("minecraft:glass");
    }

    private void drawParticleBeam() {
        if (this.getCore() == null) {
            return;
        }
        BlockPos thisPos = this.field_174879_c.func_177982_a(0, this.sphereOnTop.get() ? 1 : -1, 0);
        Vec3D coreVec = Vec3D.getDirectionVec((Vec3D)new Vec3D(thisPos).add(0.5, 0.5, 0.5), (Vec3D)new Vec3D(this.getCore().func_174877_v()).add(0.5, 0.5, 0.5));
        double coreDistance = Utils.getDistanceAtoB((Vec3D)new Vec3D(thisPos).add(0.5, 0.5, 0.5), (Vec3D)new Vec3D(this.getCore().func_174877_v().func_177963_a(0.5, 0.5, 0.5)));
        for (int i = 0; i < 100; ++i) {
            double location = (double)i / 100.0;
            Vec3D particlePos = new Vec3D(thisPos).add(0.5, 0.5, 0.5);
            particlePos.add(coreVec.x * coreDistance * location, coreVec.y * coreDistance * location, coreVec.z * coreDistance * location);
            double speed = 0.02f;
            double offset = 0.2f;
            double randX = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
            double randY = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
            double randZ = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
            particlePos.add(randX * offset, randY * offset, randZ * offset);
            this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.line_indicator, new int[]{150, 0, 255, 40 + this.field_145850_b.field_73012_v.nextInt(20)}), particlePos.x, particlePos.y, particlePos.z, randX * speed, randY * speed, randZ * speed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        Random rand = this.field_145850_b.field_73012_v;
        if (this.getCore() == null || this.particleRate.get() <= 0) {
            return;
        }
        if (this.particleRate.get() > 20) {
            this.particleRate.set(20);
        }
        if (this.particleRate.get() > 10) {
            for (int i = 0; i <= this.particleRate.get() / 10; ++i) {
                Vec3D spawn = this.getParticleSpawn(rand);
                Vec3D dest = this.getParticleDest(rand);
                this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.energy, new int[]{0, 200, 255, 200}), spawn.x, spawn.y, spawn.z, dest.x, dest.y, dest.z);
            }
        } else if (rand.nextInt(Math.max(1, 10 - this.particleRate.get())) == 0) {
            Vec3D spawn = this.getParticleSpawn(rand);
            Vec3D dest = this.getParticleDest(rand);
            this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.energy, new int[]{0, 200, 255, 200}), spawn.x, spawn.y, spawn.z, dest.x, dest.y, dest.z);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vec3D getParticleSpawn(Random random) {
        if (this.isOutputMode.get()) {
            double range = this.getCore().tier.get();
            return new Vec3D(this.getCore().func_174877_v()).add((double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range);
        }
        return this.sphereOnTop.get() ? new Vec3D(this.field_174879_c).add(0.5, 1.5, 0.5) : new Vec3D(this.field_174879_c).add(0.5, -0.5, 0.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vec3D getParticleDest(Random random) {
        if (this.isOutputMode.get()) {
            return this.sphereOnTop.get() ? new Vec3D(this.field_174879_c).add(0.5, 1.5, 0.5) : new Vec3D(this.field_174879_c).add(0.5, -0.5, 0.5);
        }
        double range = (double)this.getCore().tier.get() / 2.0;
        return new Vec3D(this.getCore().func_174877_v()).add(0.5, 0.5, 0.5).add((double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range);
    }

    @Override
    public IMultiBlockPart getController() {
        return this;
    }

    public long getExtendedStorage() {
        if (!this.hasCoreLock.get() || this.getCore() == null) {
            return 0L;
        }
        return this.getCore().getExtendedStorage();
    }

    public long getExtendedCapacity() {
        if (!this.hasCoreLock.get() || this.getCore() == null) {
            return 0L;
        }
        return this.getCore().getExtendedCapacity();
    }
}

