/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedStack;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.tileentity.StabilizedSpawnerLogic;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.ItemCore;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;

public class TileStabilizedSpawner
extends TileBCore
implements ITickableTileEntity,
IInteractTile,
IChangeListener {
    public ManagedEnum<SpawnerTier> spawnerTier = (ManagedEnum)this.register((IManagedData)new ManagedEnum("spawner_tier", (Enum)SpawnerTier.BASIC, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedStack mobSoul = (ManagedStack)this.register((IManagedData)new ManagedStack("mob_soul", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedBool isPowered = (ManagedBool)this.register((IManagedData)new ManagedBool("is_powered", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedShort spawnDelay = (ManagedShort)this.register((IManagedData)new ManagedShort("spawn_delay", 100, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedInt startSpawnDelay = (ManagedInt)this.register((IManagedData)new ManagedInt("start_spawn_delay", 100, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public StabilizedSpawnerLogic spawnerLogic = new StabilizedSpawnerLogic(this);
    private int activatingRangeFromPlayer = 24;
    public double mobRotation;

    public TileStabilizedSpawner() {
        super(DEContent.tile_stabilized_spawner);
    }

    public void func_73660_a() {
        super.tick();
        this.spawnerLogic.func_98278_g();
    }

    public boolean isActive() {
        if (this.isPowered.get() || this.mobSoul.get().func_190926_b()) {
            return false;
        }
        return !((SpawnerTier)this.spawnerTier.get()).requiresPlayer || this.field_145850_b.func_217358_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void onNeighborChange(BlockPos changePos) {
        this.isPowered.set(this.field_145850_b.func_175640_z(this.field_174879_c));
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == DEContent.mob_soul) {
            if (!this.field_145850_b.field_72995_K) {
                this.mobSoul.set(stack.func_77946_l()).func_190920_e(1);
                if (!player.func_184812_l_()) {
                    InventoryUtils.consumeHeldItem((PlayerEntity)player, (ItemStack)stack, (Hand)hand);
                }
            }
            return true;
        }
        if (stack.func_77973_b() instanceof SpawnEggItem) {
            EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            ItemStack soul = new ItemStack((IItemProvider)DEContent.mob_soul);
            DEContent.mob_soul.setEntity(type.getRegistryName(), soul);
            this.mobSoul.set(soul);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b()) {
            SpawnerTier prevTier = (SpawnerTier)this.spawnerTier.get();
            if (stack.func_77973_b() == DEContent.core_draconium) {
                if (this.spawnerTier.get() == SpawnerTier.BASIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.BASIC);
            } else if (stack.func_77973_b() == DEContent.core_wyvern) {
                if (this.spawnerTier.get() == SpawnerTier.WYVERN) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.WYVERN);
            } else if (stack.func_77973_b() == DEContent.core_awakened) {
                if (this.spawnerTier.get() == SpawnerTier.DRACONIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.DRACONIC);
            } else if (stack.func_77973_b() == DEContent.core_chaotic) {
                if (this.spawnerTier.get() == SpawnerTier.CHAOTIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.CHAOTIC);
            } else {
                return false;
            }
            ItemStack dropStack = ItemStack.field_190927_a;
            switch (prevTier) {
                case BASIC: {
                    dropStack = new ItemStack((IItemProvider)DEContent.core_draconium);
                    break;
                }
                case WYVERN: {
                    dropStack = new ItemStack((IItemProvider)DEContent.core_wyvern);
                    break;
                }
                case DRACONIC: {
                    dropStack = new ItemStack((IItemProvider)DEContent.core_awakened);
                    break;
                }
                case CHAOTIC: {
                    dropStack = new ItemStack((IItemProvider)DEContent.core_chaotic);
                }
            }
            if (!this.field_145850_b.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemEntity entityItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, dropStack);
                entityItem.func_213293_j(entityItem.func_213322_ci().field_72450_a, 0.2, entityItem.func_213322_ci().field_72449_c);
                this.field_145850_b.func_217376_c((Entity)entityItem);
                InventoryUtils.consumeHeldItem((PlayerEntity)player, (ItemStack)stack, (Hand)hand);
            }
        }
        return false;
    }

    public void writeToItemStack(CompoundNBT compound, boolean willHarvest) {
        if (willHarvest) {
            this.mobSoul.set(ItemStack.field_190927_a);
        }
        super.writeToItemStack(compound, willHarvest);
    }

    protected Entity getRenderEntity() {
        if (this.mobSoul.get().func_190926_b()) {
            return null;
        }
        return DEContent.mob_soul.getRenderEntity(this.mobSoul.get());
    }

    public static enum SpawnerTier {
        BASIC(4, true, false),
        WYVERN(6, false, false),
        DRACONIC(8, false, true),
        CHAOTIC(12, false, true);

        private int spawnCount;
        private boolean requiresPlayer;
        private boolean ignoreSpawnReq;

        private SpawnerTier(int spawnCount, boolean requiresPlayer, boolean ignoreSpawnReq) {
            this.spawnCount = spawnCount;
            this.requiresPlayer = requiresPlayer;
            this.ignoreSpawnReq = ignoreSpawnReq;
        }

        public int getRandomSpawnDelay(Random random) {
            int min = this.getMinDelay();
            int max = this.getMaxDelay();
            return min + random.nextInt(max - min);
        }

        public int getMinDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2];
        }

        public int getMaxDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2 + 1];
        }

        public int getSpawnCount() {
            return this.spawnCount;
        }

        public boolean ignoreSpawnReq() {
            return this.ignoreSpawnReq;
        }

        public boolean requiresPlayer() {
            return this.requiresPlayer;
        }

        public int getMaxCluster() {
            return (int)((double)this.spawnCount * 3.0);
        }

        public static SpawnerTier getTierFromCore(ItemCore core) {
            return core == DEContent.core_chaotic ? CHAOTIC : (core == DEContent.core_wyvern ? WYVERN : (core == DEContent.core_awakened ? DRACONIC : BASIC));
        }
    }
}

