/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.chest;

import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedFloat;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Locale;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SmeltingLogic {
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    public final ManagedEnum<FeedMode> feedMode;
    public final ManagedFloat smeltProgress;
    public final ManagedFloat smeltingPower;
    private final TileBCore tile;
    private final IItemHandler inputInv;
    private final IItemHandler outputInv;
    private final InventorySlotMapper[] wrappedSlots;
    private IItemHandlerModifiable feedSourceInv;
    private OPStorage opStorage;
    private int feedSchedule = 0;
    private boolean outputBlocked = false;
    private boolean inputInvalid = false;
    private int energyPerSmeltTick = 32;
    private InventorySimple smeltTestInv = new InventorySimple(new ItemStack[1]);

    public SmeltingLogic(TileBCore tile, IItemHandlerModifiable inputInv, IItemHandler outputInv, OPStorage opStorage) {
        this.tile = tile;
        this.inputInv = inputInv;
        this.outputInv = outputInv;
        this.opStorage = opStorage;
        this.wrappedSlots = new InventorySlotMapper[inputInv.getSlots()];
        for (int i = 0; i < inputInv.getSlots(); ++i) {
            this.wrappedSlots[i] = new InventorySlotMapper(inputInv, i);
        }
        this.feedMode = (ManagedEnum)tile.register((IManagedData)new ManagedEnum("feed_mode", (Enum)FeedMode.OFF, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
        this.smeltProgress = (ManagedFloat)tile.register((IManagedData)new ManagedFloat("smelt_progress", 0.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
        this.smeltingPower = (ManagedFloat)tile.register((IManagedData)new ManagedFloat("smelt_speed", 0.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
        this.feedMode.addValueListener(e -> this.inputInventoryChanged().attemptAutoFeed());
    }

    public void setFeedSourceInv(IItemHandlerModifiable feedSourceInv) {
        this.feedSourceInv = feedSourceInv;
    }

    public void tick(boolean enableSmelting) {
        boolean blockedAt100;
        long opStored = this.opStorage.getOPStored();
        long opMax = this.opStorage.getMaxOPStored();
        if ((enableSmelting &= opStored > 0L) && this.feedSchedule > 0 && --this.feedSchedule == 0) {
            this.attemptAutoFeed();
        }
        float availablePower = (float)opStored < (float)opMax / 4.0f ? (float)opStored / ((float)opMax / 4.0f) : 1.0f;
        boolean isSmelting = enableSmelting && !this.inputInvalid && !this.outputBlocked;
        this.smeltingPower.set(MathHelper.approachLinear((float)this.smeltingPower.get(), (float)(isSmelting ? availablePower : 0.0f), (float)0.1f));
        float maxEfficiency = 4.0f;
        float speedModifier = this.smeltingPower.get() * maxEfficiency;
        boolean bl = blockedAt100 = this.outputBlocked && this.smeltProgress.get() >= 1.0f;
        if (enableSmelting && !blockedAt100 && !this.inputInvalid) {
            this.updateSmelting(speedModifier);
        } else if (!(!(this.smeltProgress.get() > 0.0f) || this.outputBlocked && enableSmelting)) {
            this.smeltProgress.set(Math.max(0.0f, this.smeltProgress.get() - 0.01f));
        }
    }

    private void updateSmelting(float speedModifier) {
        World world = this.tile.func_145831_w();
        int validRecipes = 0;
        int completedSmelts = 0;
        int slowestRecipe = 0;
        boolean attemptSmelt = this.smeltProgress.get() >= 1.0f;
        for (int i = 0; i < this.wrappedSlots.length; ++i) {
            ItemStack result;
            FurnaceRecipe recipe;
            InventorySlotMapper slot = this.wrappedSlots[i];
            ItemStack stack = slot.func_70301_a(0);
            if (stack.func_190926_b() || stack.func_190916_E() == 1 && this.feedMode.get() == FeedMode.STiCKY || (recipe = (FurnaceRecipe)world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)slot, world).orElse(null)) == null) continue;
            ++validRecipes;
            slowestRecipe = Math.max(slowestRecipe, recipe.func_222137_e());
            if (!attemptSmelt || !InventoryUtils.insertItem((IItemHandler)this.outputInv, (ItemStack)(result = recipe.func_77572_b((IInventory)slot)), (boolean)true).func_190926_b() || this.inputInv.extractItem(i, 1, false).func_190926_b()) continue;
            InventoryUtils.insertItem((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
            this.recipesUsed.addTo((Object)recipe.func_199560_c(), 1);
            ++completedSmelts;
        }
        if (validRecipes == 0) {
            this.inputInvalid = true;
            return;
        }
        float smeltingSpeed = 1.0f / (float)slowestRecipe * speedModifier;
        int energy = Math.max(1, (int)((float)this.energyPerSmeltTick * (speedModifier < 1.0f ? speedModifier : speedModifier * speedModifier))) * validRecipes;
        if (attemptSmelt) {
            this.opStorage.modifyEnergyStored((long)(-energy));
            if (completedSmelts > 0) {
                this.smeltProgress.set(0.0f);
                this.attemptAutoFeed();
            } else {
                this.outputBlocked = true;
            }
        } else {
            long extracted = this.opStorage.modifyEnergyStored((long)(-energy));
            if ((long)energy > extracted) {
                smeltingSpeed *= (float)extracted / (float)energy;
            }
            this.smeltProgress.set(Math.min(1.0f, this.smeltProgress.get() + smeltingSpeed));
        }
    }

    private void attemptAutoFeed() {
        if (this.feedSourceInv == null || this.feedMode.get() == FeedMode.OFF || this.isInputFull()) {
            return;
        }
        this.feedSchedule = 0;
        for (int i = 0; i < this.feedSourceInv.getSlots(); ++i) {
            ItemStack stack = this.feedSourceInv.getStackInSlot(i);
            if (stack.func_190926_b() || !this.isSmeltable(stack)) continue;
            ItemStack remainder = this.insertItem(this.inputInv, stack);
            this.feedSourceInv.setStackInSlot(i, remainder);
            if (!remainder.func_190926_b() && remainder.func_190916_E() >= stack.func_190916_E() || !this.isInputFull()) continue;
            this.inputInvalid = false;
            this.outputBlocked = false;
            return;
        }
    }

    public ItemStack insertItem(IItemHandler handler, ItemStack insert) {
        insert = insert.func_77946_l();
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if ((pass == 0 || this.feedMode.get() != FeedMode.ALL) && stack.func_190926_b() || !(insert = handler.insertItem(slot, insert, false)).func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        return insert;
    }

    private boolean isInputFull() {
        int fullSlots = 0;
        for (int i = 0; i < this.inputInv.getSlots(); ++i) {
            ItemStack stack = this.inputInv.getStackInSlot(i);
            if (stack.func_190916_E() < stack.func_77976_d() && (!stack.func_190926_b() || this.feedMode.get() == FeedMode.ALL)) continue;
            ++fullSlots;
        }
        return fullSlots == this.inputInv.getSlots();
    }

    private boolean isInputEmpty() {
        for (int i = 0; i < this.inputInv.getSlots(); ++i) {
            if (this.inputInv.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public SmeltingLogic scheduleAutoFeed() {
        if (this.feedSchedule == 0 && this.feedMode.get() != FeedMode.OFF) {
            this.feedSchedule = 10;
        }
        return this;
    }

    public SmeltingLogic inputInventoryChanged() {
        this.inputInvalid = this.inputInvalid && this.isInputEmpty();
        this.outputBlocked = false;
        if (!this.isInputEmpty()) {
            this.scheduleAutoFeed();
        }
        return this;
    }

    public SmeltingLogic outputInventoryChanged() {
        this.outputBlocked = false;
        return this;
    }

    public void saveAdditionalNBT(CompoundNBT nbt) {
        CompoundNBT compound = new CompoundNBT();
        this.recipesUsed.forEach((recipe, count) -> compound.func_74768_a(recipe.toString(), count.intValue()));
        nbt.func_218657_a("recipes_used", (INBT)compound);
    }

    public void loadAdditionalNBT(CompoundNBT nbt) {
        CompoundNBT compound = nbt.func_74775_l("recipes_used");
        for (String s : compound.func_150296_c()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compound.func_74762_e(s));
        }
    }

    public boolean isSmeltable(ItemStack stack) {
        this.smeltTestInv.func_70299_a(0, stack);
        boolean ret = this.tile.func_145831_w().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this.smeltTestInv, this.tile.func_145831_w()).isPresent();
        this.smeltTestInv.func_70299_a(0, ItemStack.field_190927_a);
        return ret;
    }

    private static class InventorySlotMapper
    implements IInventory {
        private final IItemHandlerModifiable itemHandler;
        private final int slot;

        public InventorySlotMapper(IItemHandlerModifiable itemHandler, int slot) {
            this.itemHandler = itemHandler;
            this.slot = slot;
        }

        public void func_174888_l() {
            this.itemHandler.setStackInSlot(this.slot, ItemStack.field_190927_a);
        }

        public int func_70302_i_() {
            return 1;
        }

        public boolean func_191420_l() {
            return this.itemHandler.getStackInSlot(this.slot).func_190926_b();
        }

        public ItemStack func_70301_a(int index) {
            return index == 0 ? this.itemHandler.getStackInSlot(this.slot) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            if (index != 0) {
                return ItemStack.field_190927_a;
            }
            return this.itemHandler.extractItem(this.slot, count, false);
        }

        public ItemStack func_70304_b(int index) {
            if (index != 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(this.slot);
            this.itemHandler.setStackInSlot(this.slot, ItemStack.field_190927_a);
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (index == 0) {
                this.itemHandler.setStackInSlot(this.slot, stack);
            }
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }
    }

    public static enum FeedMode {
        OFF("chest/feed_off"),
        ALL("chest/feed_all"),
        FILTER("chest/feed_filter"),
        STiCKY("chest/feed_filter_sticky");

        private String sprite;

        private FeedMode(String sprite) {
            this.sprite = sprite;
        }

        public String getSprite() {
            return this.sprite;
        }

        public String localKey() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

