/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;

public class CustomBossInfoHandler
extends AbstractGui {
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    private static final Map<UUID, BossShieldInfo> events = Maps.newLinkedHashMap();
    private static final ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228640_c_((ResourceLocation)ENDER_CRYSTAL_TEXTURES);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final ModelRenderer cube;
    private static final ModelRenderer glass;
    private static final ModelRenderer base;
    public static ShaderProgram shieldShader;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(CustomBossInfoHandler::onClientDisconnect);
        MinecraftForge.EVENT_BUS.addListener(CustomBossInfoHandler::preDrawBossInfo);
    }

    public static void preDrawBossInfo(RenderGameOverlayEvent.BossInfo event) {
        UniformCache uniforms;
        if (event.getType() != RenderGameOverlayEvent.ElementType.BOSSINFO) {
            return;
        }
        ClientBossInfo info = event.getBossInfo();
        if (!events.containsKey(info.func_186737_d())) {
            return;
        }
        event.setCanceled(true);
        BossShieldInfo shieldInfo = events.get(info.func_186737_d());
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack matrixStack = event.getMatrixStack();
        RenderSystem.enableDepthTest();
        int width = event.getWindow().func_198107_o();
        int x = event.getX();
        int y = event.getY();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(GUI_BARS_LOCATION);
        CustomBossInfoHandler.drawBar(matrixStack, x, y, (BossInfo)info);
        float shield = shieldInfo.isImmune() ? 1.0f : shieldInfo.getShield();
        IRenderTypeBuffer.Impl getter = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        if (DEConfig.guardianShaders) {
            uniforms = shieldShader.pushCache();
            if (shieldInfo.isImmune()) {
                uniforms.glUniform4f("baseColour", 0.0f, 1.0f, 1.0f, 2.0f);
            } else {
                uniforms.glUniform4f("baseColour", 1.0f, 0.0f, 0.0f, 2.0f);
            }
            uniforms.glUniform1f("activation", shield);
            TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer((RenderType)new ShaderRenderType(DraconicGuardianRenderer.shieldType, shieldShader, uniforms)), matrixStack);
            CustomBossInfoHandler.drawShieldRect((IVertexBuilder)builder, x, y, 182, 6);
            getter.func_228461_a_();
        }
        if (shieldInfo.crystals > 0) {
            StringTextComponent countText = new StringTextComponent("x" + shieldInfo.crystals);
            int countWidth = mc.field_71466_p.func_238414_a_((ITextProperties)countText);
            float anim = ((float)TimeKeeper.getClientTick() + event.getPartialTicks()) * 3.0f;
            IVertexBuilder ivertexbuilder = getter.getBuffer(RENDER_TYPE);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x + 182 - countWidth - 8), (double)(y - 6), 0.0);
            matrixStack.func_227862_a_(14.0f, 14.0f, 14.0f);
            int i = OverlayTexture.field_229196_a_;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(anim));
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            glass.func_228308_a_(matrixStack, ivertexbuilder, 240, i);
            matrixStack.func_227862_a_(0.875f, 0.875f, 0.875f);
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(anim));
            glass.func_228308_a_(matrixStack, ivertexbuilder, 240, i);
            matrixStack.func_227862_a_(0.875f, 0.875f, 0.875f);
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(anim));
            cube.func_228308_a_(matrixStack, ivertexbuilder, 240, i);
            matrixStack.func_227865_b_();
            getter.func_228461_a_();
            if (DEConfig.guardianShaders) {
                uniforms = DraconicGuardianRenderer.shieldShader.pushCache();
                uniforms.glUniform4f("baseColour", 1.0f, 0.0f, 0.0f, 1.5f);
                IVertexBuilder shaderBuilder = getter.getBuffer((RenderType)new ShaderRenderType(DraconicGuardianRenderer.shieldType, DraconicGuardianRenderer.shieldShader, uniforms));
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(x + 182 - countWidth - 8), (double)(y - 6), 0.0);
                matrixStack.func_227862_a_(14.0f, 14.0f, 14.0f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(anim));
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
                glass.func_228308_a_(matrixStack, ivertexbuilder, 240, i);
                matrixStack.func_227862_a_(0.875f, 0.875f, 0.875f);
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(anim));
                glass.func_228308_a_(matrixStack, ivertexbuilder, 240, i);
                matrixStack.func_227862_a_(0.875f, 0.875f, 0.875f);
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(anim));
                cube.func_228308_a_(matrixStack, ivertexbuilder, 240, i);
                matrixStack.func_227865_b_();
                getter.func_228461_a_();
            }
            mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)new StringTextComponent("x" + shieldInfo.crystals), (float)(x + 182 - countWidth), (float)y - 9.0f, 0xFFFFFF);
        }
        ITextComponent itextcomponent = info.func_186744_e();
        int stringWidth = mc.field_71466_p.func_238414_a_((ITextProperties)itextcomponent);
        int stringX = shieldInfo.crystals > 0 ? x : width / 2 - stringWidth / 2;
        int stringY = y - 9;
        matrixStack.func_227861_a_(0.0, 0.0, 16.0);
        mc.field_71466_p.func_243246_a(matrixStack, itextcomponent, (float)stringX, (float)stringY, 0xFF0000);
    }

    private static void drawBar(MatrixStack matrixStack, int x, int y, BossInfo info) {
        int i;
        CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, info.func_186736_g().ordinal() * 5 * 2, 182, 5);
        if (info.func_186740_h() != BossInfo.Overlay.PROGRESS) {
            CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, 80 + (info.func_186740_h().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i = (int)(info.func_186738_f() * 183.0f)) > 0) {
            CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, info.func_186736_g().ordinal() * 5 * 2 + 5, i, 5);
            if (info.func_186740_h() != BossInfo.Overlay.PROGRESS) {
                CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, 80 + (info.func_186740_h().ordinal() - 1) * 5 * 2 + 5, i, 5);
            }
        }
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        events.clear();
    }

    public static void handlePacket(MCDataInput input) {
        UUID id = input.readUUID();
        byte op = input.readByte();
        switch (op) {
            case 0: {
                events.put(id, new BossShieldInfo(input.readFloat(), input.readByte(), input.readBoolean()));
                break;
            }
            case 1: {
                events.remove(id);
                break;
            }
            case 2: {
                events.get(id).setShield(input.readFloat());
                break;
            }
            case 3: {
                events.get(id).setCrystals(input.readByte());
                break;
            }
            case 4: {
                events.get(id).setImmune(input.readBoolean());
            }
        }
    }

    public static void drawRect(MatrixStack stack, int x, int y, int u, int v, int width, int height) {
        CustomBossInfoHandler.func_238464_a_((MatrixStack)stack, (int)x, (int)y, (int)0, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void drawShieldRect(IVertexBuilder builder, int x, int y, int width, int height) {
        CustomBossInfoHandler.drawQuad(builder, x, x + width, y, y + height, 0, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static void drawQuad(IVertexBuilder builder, int x, int xMax, int y, int yMax, int z, float u, float uMax, float v, float vMax) {
        builder.func_225582_a_((double)x, (double)yMax, (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, vMax).func_181675_d();
        builder.func_225582_a_((double)xMax, (double)yMax, (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMax).func_181675_d();
        builder.func_225582_a_((double)xMax, (double)y, (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, v).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, v).func_181675_d();
    }

    static {
        glass = new ModelRenderer(64, 32, 0, 0);
        glass.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        cube = new ModelRenderer(64, 32, 32, 0);
        cube.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        base = new ModelRenderer(64, 32, 0, 16);
        base.func_228300_a_(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f);
        shieldShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/guardian_shield.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/guardian_shield.frag")).uniform("time", UniformType.FLOAT).uniform("baseColour", UniformType.VEC4).uniform("activation", UniformType.FLOAT)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    }

    public static class BossShieldInfo {
        protected float lastPower;
        protected float targetPower;
        protected long setTime;
        protected int crystals;
        protected boolean immune;

        public BossShieldInfo(float power, int crystals, boolean immune) {
            this.lastPower = power;
            this.targetPower = power;
            this.crystals = crystals;
            this.immune = immune;
            this.setTime = Util.func_211177_b();
        }

        public BossShieldInfo setShield(float power) {
            this.lastPower = this.getShield();
            this.targetPower = power;
            this.setTime = Util.func_211177_b();
            return this;
        }

        public float getShield() {
            long i = Util.func_211177_b() - this.setTime;
            float f = MathHelper.func_76131_a((float)((float)i / 100.0f), (float)0.0f, (float)1.0f);
            return MathHelper.func_219799_g((float)f, (float)this.lastPower, (float)this.targetPower);
        }

        public void setCrystals(int crystals) {
            this.crystals = crystals;
        }

        public int getCrystals() {
            return this.crystals;
        }

        public void setImmune(boolean immune) {
            this.immune = immune;
        }

        public boolean isImmune() {
            return this.immune;
        }
    }
}

