/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.client.render.effect.RenderEnergyBolt;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.world.World;

public class EffectTrackerCelestialManipulator {
    public static double interpPosX = 0.0;
    public static double interpPosY = 0.0;
    public static double interpPosZ = 0.0;
    private Random rand = new Random();
    public Vec3D effectFocus;
    public Vec3D linkPos = null;
    private int renderBolt = 0;
    private float rotation;
    private float rotationSpeed = 2.0f;
    private float aRandomFloat = 0.0f;
    public boolean positionLocked = false;
    public Vec3D startPos;
    public Vec3D pos;
    public Vec3D prevPos = new Vec3D();
    public Vec3D circlePosition = new Vec3D();
    private World world;
    private long boltSeed = 0L;
    public boolean renderBolts = true;
    public float alpha = 0.0f;
    public float scale = 1.0f;
    public float red = 0.0f;
    public float green = 1.0f;
    public float blue = 1.0f;

    public EffectTrackerCelestialManipulator(World world, Vec3D pos, Vec3D effectFocus) {
        this.world = world;
        this.effectFocus = effectFocus;
        this.rotation = this.rand.nextInt(1000);
        this.aRandomFloat = this.rand.nextFloat();
        this.pos = pos.copy();
        this.startPos = pos.copy();
        this.prevPos.set(pos);
        this.red = 0.1f;
        this.green = 0.1f;
        this.alpha = 1.0f;
    }

    public void onUpdate() {
        this.prevPos.set(this.pos);
        if (this.renderBolt > 0) {
            --this.renderBolt;
        }
        this.renderBolt = 1;
        this.boltSeed = this.rand.nextLong();
        this.rotationSpeed = -1.0f;
        this.rotation += this.rotationSpeed;
    }

    public void renderEffect(Tessellator tessellator, float partialTicks) {
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        CCRenderState ccrs = CCRenderState.instance();
        float relativeX = (float)(this.prevPos.x + (this.pos.x - this.prevPos.x) * (double)partialTicks - interpPosX);
        float relativeY = (float)(this.prevPos.y + (this.pos.y - this.prevPos.y) * (double)partialTicks - interpPosY);
        float relativeZ = (float)(this.prevPos.z + (this.pos.z - this.prevPos.z) * (double)partialTicks - interpPosZ);
        float correctX = (float)(this.prevPos.x + (this.pos.x - this.prevPos.x) * (double)partialTicks);
        float correctY = (float)(this.prevPos.y + (this.pos.y - this.prevPos.y) * (double)partialTicks);
        float correctZ = (float)(this.prevPos.z + (this.pos.z - this.prevPos.z) * (double)partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        RenderSystem.translatef((float)relativeX, (float)relativeY, (float)relativeZ);
        RenderSystem.rotatef((float)(this.rotation + partialTicks * this.rotationSpeed), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.translatef((float)(-relativeX), (float)(-relativeY), (float)(-relativeZ));
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181707_g, vertexbuffer);
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3((double)relativeX, (double)relativeY, (double)relativeZ), (Rotation)new Rotation(0.0, new Vector3(0.0, 0.0, 0.0)), (double)(0.15 * (double)this.scale));
        ccrs.bind(vertexbuffer);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)relativeX, (float)relativeY, (float)relativeZ);
        int segments = Math.max(4, (int)(8.0f * this.scale));
        if (this.renderBolt > 0 && this.scale > 0.0f && this.renderBolts) {
            RenderEnergyBolt.renderBoltBetween(new Vec3D(), this.effectFocus.copy().subtract((double)correctX, (double)correctY, (double)correctZ), 0.05 * (double)this.scale, (double)this.scale * 0.5, segments, this.boltSeed, false);
        }
        if (this.linkPos != null && this.scale > 0.0f) {
            RenderEnergyBolt.renderBoltBetween(new Vec3D(), this.linkPos.copy().subtract((double)correctX, (double)correctY, (double)correctZ), 0.05 * (double)this.scale, (double)this.scale * 0.5, segments, this.boltSeed, false);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableLighting();
        RenderSystem.popMatrix();
    }
}

