/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity.projectile;

import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.entity.projectile.DraconicArrowEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DraconicArrowRenderer
extends EntityRenderer<DraconicArrowEntity> {
    public static final ResourceLocation RES_ARROW = new ResourceLocation("textures/entity/projectiles/arrow.png");
    public static final ResourceLocation RES_TIPPED_ARROW = new ResourceLocation("textures/entity/projectiles/tipped_arrow.png");

    public DraconicArrowRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(DraconicArrowEntity arrowEntity, float entityYaw, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLightIn) {
        mStack.func_227860_a_();
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)arrowEntity.field_70126_B, (float)arrowEntity.field_70177_z) - 90.0f));
        mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)arrowEntity.field_70127_C, (float)arrowEntity.field_70125_A)));
        float f9 = (float)arrowEntity.field_70249_b - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -MathHelper.func_76126_a((float)(f9 * 3.0f)) * f9;
            mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f10));
        }
        mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
        mStack.func_227862_a_(0.05625f, 0.05625f, 0.05625f);
        mStack.func_227861_a_(-4.0, 0.0, 0.0);
        IVertexBuilder ivertexbuilder = getter.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(arrowEntity)));
        MatrixStack.Entry matrixstack$entry = mStack.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLightIn);
        for (int j = 0; j < 4; ++j) {
            mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLightIn);
        }
        mStack.func_227865_b_();
        super.func_225623_a_((Entity)arrowEntity, entityYaw, partialTicks, mStack, getter, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, IVertexBuilder vertexBuilder, int offsetX, int offsetY, int offsetZ, float textureX, float textureY, int p_229039_9_, int p_229039_10_, int p_229039_11_, int packedLightIn) {
        vertexBuilder.func_227888_a_(matrix, (float)offsetX, (float)offsetY, (float)offsetZ).func_225586_a_(255, 255, 255, 255).func_225583_a_(textureX, textureY).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(normals, (float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_).func_181675_d();
    }

    public ResourceLocation getTextureLocation(DraconicArrowEntity entity) {
        return entity.getColor() > 0 ? RES_TIPPED_ARROW : RES_ARROW;
    }

    public static void renderEnergyBolt(Vector3 startPos, Vector3 endPos, Matrix4 mat, IRenderTypeBuffer getter, float partialTicks) {
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(RenderType.func_228657_l_()), (Transformation)mat);
    }

    public static void rendeArcP2P(MatrixStack mStack, IRenderTypeBuffer getter, Vector3 startPos, Vector3 endPos, int segCount, long randSeed, float scaleMod, float deflectMod, boolean autoScale, float segTaper, int colour) {
        double height = endPos.y - startPos.y;
        float relScale = autoScale ? (float)height / 128.0f : 1.0f;
        float segHeight = (float)height / (float)segCount;
        float[] segXOffset = new float[segCount + 1];
        float[] segZOffset = new float[segCount + 1];
        float xOffSum = 0.0f;
        float zOffSum = 0.0f;
        Random random = new Random(randSeed);
        for (int segment = 0; segment < segCount + 1; ++segment) {
            segXOffset[segment] = xOffSum + (float)startPos.x;
            segZOffset[segment] = zOffSum + (float)startPos.z;
            if (segment >= segCount) continue;
            xOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
            zOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
        }
        xOffSum -= (float)(endPos.x - startPos.x);
        zOffSum -= (float)(endPos.z - startPos.z);
        IVertexBuilder builder = getter.getBuffer(RenderType.func_228657_l_());
        Matrix4f matrix4f = mStack.func_227866_c_().func_227870_a_();
        for (int layer = 0; layer < 4; ++layer) {
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            float alpha = 0.3f;
            if (layer == 0) {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            for (int seg = 0; seg < segCount; ++seg) {
                float pos = (float)seg / (float)segCount;
                float x = segXOffset[seg] - xOffSum * pos;
                float z = segZOffset[seg] - zOffSum * pos;
                float nextPos = (float)(seg + 1) / (float)segCount;
                float nextX = segXOffset[seg + 1] - xOffSum * nextPos;
                float nextZ = segZOffset[seg + 1] - zOffSum * nextPos;
                float layerOffsetA = (0.1f + (float)layer * 0.2f * (1.0f + segTaper)) * relScale * scaleMod;
                float layerOffsetB = (0.1f + (float)layer * 0.2f * (1.0f - segTaper)) * relScale * scaleMod;
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, false, true, false, segHeight);
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, false, true, true, segHeight);
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, true, false, true, segHeight);
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, true, false, false, segHeight);
            }
        }
    }

    private static void addSegmentQuad(Matrix4f matrix4f, IVertexBuilder builder, float x1, float yOffset, float z1, int segIndex, float x2, float z2, float red, float green, float blue, float alpha, float offsetA, float offsetB, boolean invA, boolean invB, boolean invC, boolean invD, float segHeight) {
        builder.func_227888_a_(matrix4f, x1 + (invA ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invB ? offsetB : -offsetB)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, x2 + (invA ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invB ? offsetA : -offsetA)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, x2 + (invC ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invD ? offsetA : -offsetA)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, x1 + (invC ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invD ? offsetB : -offsetB)).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }
}

