/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.lib.ISidedTileHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class GeneratorSoundHandler
implements ISidedTileHandler {
    private TileGenerator tile;
    private GeneratorSound activeSound = null;
    private boolean currentHigh = false;
    private boolean startHigh = false;

    public GeneratorSoundHandler(TileGenerator tile) {
        this.tile = tile;
    }

    @Override
    public void tick() {
        if (!this.tile.active.get()) {
            if (this.activeSound != null) {
                this.activeSound.fadeDown = true;
                if (this.activeSound.func_147667_k()) {
                    this.activeSound = null;
                }
            }
            return;
        }
        TileGenerator.Mode mode = (TileGenerator.Mode)this.tile.mode.get();
        if (this.activeSound == null || this.activeSound.func_147667_k()) {
            if (mode.index >= 2) {
                this.activeSound = new GeneratorSound(this.tile, DESounds.generator2, this.startHigh ? 1.5f : 0.5f);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activeSound);
                this.currentHigh = true;
            } else {
                this.activeSound = new GeneratorSound(this.tile, DESounds.generator1, this.startHigh ? 1.0f : 0.5f);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activeSound);
                this.currentHigh = false;
            }
        }
        if (mode.index >= 2) {
            if (!this.currentHigh) {
                this.activeSound.fadeUp = true;
                this.startHigh = false;
            } else {
                this.activeSound.targetPitch = mode == TileGenerator.Mode.NORMAL ? 0.6f : (mode == TileGenerator.Mode.PERFORMANCE ? 1.3f : 1.6f);
            }
        } else if (this.currentHigh) {
            this.activeSound.fadeDown = true;
            this.startHigh = true;
        } else {
            this.activeSound.targetPitch = mode == TileGenerator.Mode.ECO_PLUS ? 0.5f : 0.7f;
        }
    }

    public class GeneratorSound
    extends SimpleSound
    implements ITickableSound {
        public boolean donePlaying;
        private TileGenerator tile;
        private float targetPitch;
        boolean fadeUp;
        boolean fadeDown;

        public GeneratorSound(TileGenerator tile, SoundEvent sound, float startPitch) {
            super(sound, SoundCategory.BLOCKS, 0.3f, 1.0f, tile.func_174877_v());
            this.donePlaying = false;
            this.fadeUp = false;
            this.fadeDown = false;
            this.tile = tile;
            this.field_147659_g = true;
            this.field_147663_c = startPitch;
            this.targetPitch = startPitch;
        }

        public boolean func_147667_k() {
            return this.donePlaying;
        }

        public void func_73660_a() {
            this.field_147660_d = (float)this.tile.func_174877_v().func_177958_n() + 0.5f;
            this.field_147661_e = (float)this.tile.func_174877_v().func_177956_o() + 0.5f;
            this.field_147658_f = (float)this.tile.func_174877_v().func_177952_p() + 0.5f;
            if (this.fadeUp) {
                this.targetPitch = 1.5f;
            } else if (this.fadeDown) {
                this.targetPitch = 0.5f;
            }
            if (this.fadeUp && this.field_147663_c >= 1.0f || this.fadeDown && (double)this.field_147663_c <= 0.55 || this.tile.func_145837_r()) {
                this.donePlaying = true;
                this.field_147659_g = false;
            }
            this.field_147663_c = (float)MathHelper.approachExp((double)this.field_147663_c, (double)this.targetPitch, (double)0.05);
        }
    }
}

