/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.particle.GuardianChargeParticle;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.handlers.DESounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ChargeUpPhase
extends Phase {
    protected int requiredChargeTime;
    protected int chargeTime;
    protected int chargedTime;
    private int effectTimer = 0;
    private int effectTime = 0;
    public boolean disableFlight = false;
    public boolean trapPlayers = false;
    float speedMod;
    int offGroundTime = 0;

    public ChargeUpPhase(DraconicGuardianEntity guardian, int requiredChargeTime) {
        super(guardian);
        this.requiredChargeTime = requiredChargeTime;
    }

    @Override
    public boolean getIsStationary() {
        return true;
    }

    @Override
    public void initPhase() {
        this.chargeTime = 0;
        this.chargedTime = 0;
        this.effectTimer = 0;
    }

    public void resetCharge() {
        this.chargeTime = 0;
    }

    @Override
    public void serverTick() {
        GuardianFightManager manager;
        BlockPos origin;
        GuardianFightManager manager2;
        if (this.chargeTime < this.requiredChargeTime) {
            ++this.chargeTime;
        } else {
            ++this.chargedTime;
        }
        if (this.trapPlayers && this.isCharged() && (manager2 = this.guardian.getFightManager()) != null) {
            for (PlayerEntity playerEntity : manager2.getTrackedPlayers()) {
                if (!this.isValidTarget((LivingEntity)playerEntity) || !(playerEntity.func_226278_cu_() < (double)(manager2.getArenaOrigin().func_177956_o() - 10))) continue;
                TeleportUtils.teleportEntity((Entity)playerEntity, (RegistryKey)playerEntity.field_70170_p.func_234923_W_(), (double)playerEntity.func_226277_ct_(), (double)(manager2.getArenaOrigin().func_177956_o() + 15), (double)playerEntity.func_226281_cx_());
            }
        }
        if ((origin = this.guardian.getArenaOrigin()) == null) {
            return;
        }
        if (this.disableFlight && this.getChargeProgress() > 0.5 && (manager = this.guardian.getFightManager()) != null) {
            for (PlayerEntity playerEntity : manager.getTrackedPlayers()) {
                if (!(playerEntity.func_226278_cu_() > (double)(origin.func_177956_o() + 8)) || !playerEntity.field_71075_bZ.field_75100_b) continue;
                playerEntity.field_71075_bZ.field_75100_b = false;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        double z;
        int i;
        if (this.chargeTime < this.requiredChargeTime) {
            ++this.chargeTime;
        } else {
            ++this.chargedTime;
        }
        BlockPos origin = this.guardian.getArenaOrigin();
        if (origin == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !this.isValidTarget((LivingEntity)player)) {
            return;
        }
        if (this.effectTimer == 0) {
            this.speedMod = (float)this.getChargeProgress();
            this.effectTime = this.effectTimer = (int)(20.0f - this.speedMod * 10.0f);
            this.guardian.field_70170_p.func_184134_a(this.guardian.func_226277_ct_(), this.guardian.func_226278_cu_(), this.guardian.func_226281_cx_(), DESounds.crystalBeam, SoundCategory.HOSTILE, 64.0f, 1.0f + this.speedMod, false);
            if (origin != null) {
                for (i = 0; i < 32; ++i) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new GuardianChargeParticle((ClientWorld)this.guardian.field_70170_p, Vector3.fromBlockPosCenter((BlockPos)origin), Vector3.fromEntity((Entity)this.guardian), (double)i / 32.0, this.effectTime, this.guardian.getPhaseManager()));
                }
            }
        } else {
            --this.effectTimer;
        }
        if (this.trapPlayers) {
            for (i = 0; i < 4; ++i) {
                float randDir = this.random.nextFloat() * (float)Math.PI * 2.0f;
                int randDist = 95 + this.random.nextInt(30);
                double x = this.guardian.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)randDir) * (float)randDist);
                z = this.guardian.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)randDir) * (float)randDist);
                double y = this.guardian.func_226278_cu_() - 8.0 - (double)this.random.nextInt(32);
                Vector3 motion = new Vector3(this.guardian.func_226277_ct_(), y, this.guardian.func_226281_cx_()).subtract(x, y, z).normalize().multiply((1.0 + this.random.nextDouble()) * this.getChargeProgress());
                this.guardian.field_70170_p.func_195590_a((IParticleData)DEParticles.guardian_cloud, true, x, y, z, motion.x, motion.y, motion.z);
            }
            Vector3 center = new Vector3(this.guardian.func_226277_ct_(), this.guardian.func_226278_cu_() - 32.0, this.guardian.func_226281_cx_());
            int threshold = 85;
            if (!player.field_71075_bZ.field_75098_d) {
                if (player.func_195048_a(center.vec3()) > (double)(threshold * threshold)) {
                    double distanceOver = Math.sqrt(player.func_195048_a(center.vec3())) - (double)threshold;
                    Vector3 forceVec = center.copy().subtract(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()).normalize().multiply(1.0 * (distanceOver / 10.0) * this.getChargeProgress());
                    this.debug(forceVec.toString());
                    player.func_213317_d(player.func_213322_ci().func_178787_e(forceVec.vec3()));
                }
                if (player.func_226278_cu_() < (double)origin.func_177956_o()) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, ((double)origin.func_177956_o() - player.func_226278_cu_()) / 5.0 * this.getChargeProgress(), 0.0));
                }
            }
        }
        if (this.disableFlight && player != null && !player.field_71075_bZ.field_75098_d && this.getChargeProgress() > 0.5) {
            if (player.func_226278_cu_() > (double)(origin.func_177956_o() + 8)) {
                if (player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = false;
                }
                if (player.func_184613_cA()) {
                    Vector3d motion = player.func_213322_ci();
                    player.func_213293_j(motion.field_72450_a * 0.75, motion.field_72448_b > 0.0 ? motion.field_72448_b * 0.75 : motion.field_72448_b, motion.field_72449_c * 0.75);
                }
            }
            if (player.func_233570_aj_() || player.func_226278_cu_() < (double)(origin.func_177956_o() + 8)) {
                this.offGroundTime = 0;
            } else {
                ++this.offGroundTime;
                if (this.offGroundTime > 40) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)Math.min(this.offGroundTime - 40, 200) / -100.0, 0.0));
                }
            }
            for (i = 0; i < 2; ++i) {
                double y;
                double x = this.guardian.func_226277_ct_() - 95.0 + (double)this.random.nextInt(190);
                if (!(this.guardian.func_70092_e(x, y = this.guardian.func_226278_cu_() - (double)this.random.nextInt(35), z = this.guardian.func_226281_cx_() - 95.0 + (double)this.random.nextInt(190)) < 10000.0)) continue;
                this.guardian.field_70170_p.func_195590_a((IParticleData)DEParticles.guardian_cloud, true, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public float animState() {
        return this.effectTimer > 0 ? (float)this.effectTimer / (float)this.effectTime : 0.0f;
    }

    public double getChargeProgress() {
        return (double)this.chargeTime / (double)this.requiredChargeTime;
    }

    public boolean isCharged() {
        return this.chargeTime >= this.requiredChargeTime;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        if (this.isInvulnerable()) {
            if (source.func_76364_f() instanceof AbstractArrowEntity) {
                source.func_76364_f().func_70015_d(1);
            }
            return 0.0f;
        }
        return super.onAttacked(source, damage, shield, effective);
    }

    @Override
    public void handlePacket(MCDataInput input, int func) {
        if (func == 0) {
            this.resetCharge();
        }
    }

    @Override
    public boolean isInvulnerable() {
        return true;
    }
}

