/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.damage.DraconicDamage;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.logging.log4j.Logger;

public class ChargingPlayerPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private int timeSinceCharge;
    private int tick;
    private float damageTaken;
    private float abortDamageThreshold = 0.05f;
    private double closestApproach;
    private boolean charging = false;
    private Vector3d targetLocation;
    private PlayerEntity targetPlayer;

    public ChargingPlayerPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    @Override
    public void serverTick() {
        if (this.targetPlayer == null || this.isValidTarget((LivingEntity)this.targetPlayer)) {
            this.debug("Aborting charge player as no target was set or target is dead");
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
        } else if (this.timeSinceCharge > 0 && this.timeSinceCharge >= 100) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed().prevAttackFailed();
            this.debug("Aborting charge, Timed out");
        } else {
            double distance = this.targetPlayer.func_70032_d((Entity)this.guardian);
            if (distance - this.closestApproach > 16.0 && this.timeSinceCharge > 10) {
                this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed().prevAttackFailed();
                this.debug("Aborting charge, Player got away");
            } else {
                this.closestApproach = Math.min(distance, this.closestApproach);
                this.targetLocation = this.targetPlayer.func_213303_ch();
                if (!this.charging) {
                    double tRelZ;
                    double tRelX = this.targetLocation.field_72450_a - this.guardian.func_226277_ct_();
                    double relTargetAngle = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)tRelX, (double)(tRelZ = this.targetLocation.field_72449_c - this.guardian.func_226281_cx_())) * 57.2957763671875 - (double)this.guardian.field_70177_z)), (double)-50.0, (double)50.0);
                    boolean bl = this.charging = Math.abs(relTargetAngle) < 1.0;
                    if (this.charging) {
                        this.debug("CHARGE!");
                    }
                } else {
                    ++this.timeSinceCharge;
                }
                if (distance <= 5.0) {
                    this.guardian.getPhaseManager().setPhase(PhaseType.START);
                    this.debug("Charge Successful");
                    this.targetPlayer.func_70097_a(new DraconicDamage("draconicevolution.draconic_guardian", (Entity)this.guardian, TechLevel.CHAOTIC).func_151518_m().func_76348_h(), 150.0f);
                    this.guardian.func_184185_a(SoundEvents.field_187537_bA, 20.0f, 0.95f + this.guardian.func_70681_au().nextFloat() * 0.2f);
                    this.guardian.func_184185_a(SoundEvents.field_187537_bA, 20.0f, 0.95f + this.guardian.func_70681_au().nextFloat() * 0.2f);
                    DraconicNetwork.sendImpactEffect(this.guardian.field_70170_p, this.targetPlayer.func_233580_cy_(), 0);
                }
            }
        }
        if (this.tick > 200) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed().prevAttackFailed();
            this.debug("Aborting charge, Master timed out");
        } else if (this.charging && this.timeSinceCharge < 20 && this.timeSinceCharge % 5 == 0) {
            this.guardian.func_184185_a(SoundEvents.field_187525_aO, 20.0f, 0.95f + this.guardian.func_70681_au().nextFloat() * 0.2f);
        }
        ++this.tick;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.timeSinceCharge = 0;
        this.closestApproach = 256.0;
        this.charging = false;
        this.tick = 0;
        this.damageTaken = 0.0f;
    }

    @Override
    public void targetPlayer(PlayerEntity player) {
        this.targetPlayer = player;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<ChargingPlayerPhase> getType() {
        return PhaseType.CHARGE_PLAYER;
    }

    @Override
    public double getGuardianSpeed() {
        return this.charging ? 3.0 : 0.5;
    }

    @Override
    public float getYawFactor() {
        return super.getYawFactor() * (float)(this.charging ? 2 : 1);
    }

    @Override
    public boolean highVerticalAgility() {
        return true;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        this.damageTaken += damage;
        float f = shield > 0.0f ? (float)DEConfig.guardianShield * this.abortDamageThreshold : (float)DEConfig.guardianHealth * this.abortDamageThreshold;
        if (this.damageTaken > f) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            this.debug("Aborting charge, Damage Taken");
        }
        return super.onAttacked(source, damage, shield, effective);
    }
}

