/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.damage.DraconicIndirectEntityDamage;
import com.brandon3055.draconicevolution.client.sound.GuardianLaserSound;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.entity.guardian.control.StartPhase;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LaserBeamPhase
extends ChargeUpPhase {
    private boolean soundInitialized = false;
    private PlayerEntity attackTarget = null;
    private Vector3 beamPos = new Vector3();
    private DamageSource damage;
    private int laserTime = 0;
    private int maxLaserTime;

    public LaserBeamPhase(DraconicGuardianEntity guardian) {
        super(guardian, 60);
        this.damage = new DraconicIndirectEntityDamage("draconicevolution.guardian_laser", (Entity)guardian, (Entity)guardian, TechLevel.CHAOTIC).func_151518_m().func_76348_h().func_82726_p().func_94540_d();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.attackTarget == null || !this.isValidTarget((LivingEntity)this.attackTarget)) {
            Vector3d focus = Vector3d.func_237489_a_((Vector3i)this.guardian.getArenaOrigin());
            List targetOptions = this.guardian.field_70170_p.func_217369_A().stream().filter(e -> e.func_195048_a(focus) <= 40000.0).filter(e -> StartPhase.AGRO_TARGETS.func_221015_a((LivingEntity)this.guardian, (LivingEntity)e)).collect(Collectors.toList());
            if (targetOptions.isEmpty()) {
                this.guardian.getPhaseManager().setPhase(PhaseType.START);
                return;
            }
            this.attackTarget = targetOptions.size() == 1 ? (PlayerEntity)targetOptions.get(0) : (PlayerEntity)targetOptions.get(this.random.nextInt(targetOptions.size()));
            this.beamPos = Vector3.fromEntityCenter((Entity)this.attackTarget);
        }
        Vector3 guardianPos = Vector3.fromEntity((Entity)this.guardian);
        Vector3 targetPos = Vector3.fromEntity((Entity)this.attackTarget);
        Vector3 dirVec = targetPos.copy();
        dirVec.subtract(guardianPos);
        dirVec.normalize();
        float targetYaw = (float)(MathHelper.func_181159_b((double)dirVec.x, (double)dirVec.z) * 57.2957763671875);
        this.guardian.field_70177_z = -targetYaw - 180.0f;
        Vector3 headPos = guardianPos.copy();
        float rotation = (this.guardian.field_70177_z - 90.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(MathHelper.func_76134_b((float)rotation) * 7.0f), 0.0, (double)(MathHelper.func_76126_a((float)rotation) * 7.0f));
        this.beamPos = Vector3.fromEntityCenter((Entity)this.attackTarget);
        boolean hit = true;
        BlockRayTraceResult result = this.guardian.field_70170_p.func_217299_a(new RayTraceContext(headPos.vec3(), this.beamPos.vec3(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.guardian));
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            this.beamPos = new Vector3(result.func_216347_e());
            hit = false;
        }
        if (this.getBeamCharge() > 0.5f) {
            float beamPower = (this.getBeamCharge() - 0.5f) / 0.5f;
            DraconicNetwork.sendGuardianBeam(this.guardian.field_70170_p, headPos, this.beamPos, beamPower);
            if (!hit & this.chargedTime % 2 == 0) {
                this.guardian.field_70170_p.func_230546_a_(null, this.damage, null, this.beamPos.x, this.beamPos.y, this.beamPos.z, 8.0f, false, Explosion.Mode.DESTROY);
            } else if (hit) {
                this.attackTarget.func_70097_a(this.damage, beamPower * 20.0f);
            }
            if (this.getBeamCharge() >= 1.0f) {
                GuardianFightManager manager;
                if (this.laserTime == 0 && (manager = this.guardian.getFightManager()) != null) {
                    manager.guardianUpdate(this.guardian);
                }
                ++this.laserTime;
            }
        }
        if (this.laserTime >= this.maxLaserTime) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.isCharged() && !this.soundInitialized) {
            this.soundInitialized = true;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new GuardianLaserSound(this.guardian.func_233580_cy_(), this));
        }
    }

    @Override
    public void initPhase() {
        super.initPhase();
        this.soundInitialized = false;
        this.laserTime = 0;
        this.maxLaserTime = 120 + this.random.nextInt(120);
    }

    public float getBeamCharge() {
        return Math.min((float)this.chargedTime / 120.0f, 1.0f);
    }

    public float getSoundPitch() {
        return 0.5f + this.getBeamCharge() * 1.5f;
    }

    @Override
    public boolean isInvulnerable() {
        return (double)this.getBeamCharge() < 0.5;
    }

    public PhaseType<LaserBeamPhase> getType() {
        return PhaseType.LASER_BEAM;
    }
}

