/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.crafttweaker.handler;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;

public final class FusionIngredientReplacementRule
implements IReplacementRule {
    private final FusionRecipe.FusionIngredient from;
    private final FusionRecipe.FusionIngredient to;

    private FusionIngredientReplacementRule(FusionRecipe.FusionIngredient from, FusionRecipe.FusionIngredient to) {
        this.from = from;
        this.to = to;
    }

    public static IReplacementRule create(FusionRecipe.FusionIngredient from, FusionRecipe.FusionIngredient to) {
        return FusionIngredientReplacementRule.areTheSame(from, to) ? IReplacementRule.EMPTY : new FusionIngredientReplacementRule(from, to);
    }

    private static boolean areTheSame(FusionRecipe.FusionIngredient a, FusionRecipe.FusionIngredient b) {
        IIngredient aIngredient = IIngredient.fromIngredient((Ingredient)a.get());
        IIngredient bIngredient = IIngredient.fromIngredient((Ingredient)b.get());
        if (a.consume() != b.consume()) {
            return false;
        }
        return a == b || Objects.equals(a, b) || aIngredient.contains(bIngredient) && bIngredient.contains(aIngredient);
    }

    public <T, U extends IRecipe<?>> Optional<T> getReplacement(T ingredient, Class<T> type, U recipe) {
        return IReplacementRule.withType(ingredient, type, recipe, FusionRecipe.FusionIngredient.class, this::getIIngredientReplacement);
    }

    private <U extends IRecipe<?>> Optional<FusionRecipe.FusionIngredient> getIIngredientReplacement(FusionRecipe.FusionIngredient original, U recipe) {
        return FusionIngredientReplacementRule.areTheSame(this.from, original) ? Optional.of(this.to) : Optional.empty();
    }

    public String describe() {
        return String.format("Replacing FusionIngredient.of(%s, %s) --> FusionIngredient.of(%s, %s)", IIngredient.fromIngredient((Ingredient)this.from.get()).getCommandString(), this.from.consume(), IIngredient.fromIngredient((Ingredient)this.to.get()).getCommandString(), this.to.consume());
    }
}

