/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiProgressIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.client.gui.GuiDraconiumChest;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.GuiConfigurableItem;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeCategory;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeTransferHelper;
import com.brandon3055.draconicevolution.integration.jei.RecipeCategoryUids;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class DEJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers = null;
    public static IJeiRuntime jeiRuntime = null;
    @Nullable
    private FusionRecipeCategory fusionRecipeCategory;

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(GuiConfigurableItem.class, gui -> null);
        registration.addGuiContainerHandler(GuiDraconiumChest.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiDraconiumChest>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(GuiDraconiumChest gui, double mouseX, double mouseY) {
                if (gui.colourDialog.isVisible()) {
                    return Collections.emptyList();
                }
                GuiTexture craftIcon = gui.craftIcon;
                GuiProgressIcon smeltArrow = gui.furnaceProgress;
                IGuiClickableArea craftingArea = IGuiClickableArea.createBasic((int)(craftIcon.xPos() - gui.guiLeft()), (int)(craftIcon.yPos() - gui.guiTop()), (int)craftIcon.xSize(), (int)craftIcon.ySize(), (ResourceLocation[])new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
                IGuiClickableArea smeltingArea = IGuiClickableArea.createBasic((int)(smeltArrow.xPos() - gui.guiLeft()), (int)(smeltArrow.yPos() - gui.guiTop()), (int)smeltArrow.xSize(), (int)smeltArrow.ySize(), (ResourceLocation[])new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
                return Lists.newArrayList((Object[])new IGuiClickableArea[]{craftingArea, smeltingArea});
            }
        });
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerIngredients(IModIngredientRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.fusionRecipeCategory = new FusionRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.fusionRecipeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull((Object)this.fusionRecipeCategory, (String)"fusionRecipeCategory");
        jeiHelpers = registration.getJeiHelpers();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        registration.addRecipes((Collection)world.func_199532_z().func_241447_a_(DraconicAPI.FUSION_RECIPE_TYPE), RecipeCategoryUids.FUSION_CRAFTING);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FusionRecipeTransferHelper(stackHelper, transferHelper), RecipeCategoryUids.FUSION_CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<ContainerDraconiumChest>(){

            public Class<ContainerDraconiumChest> getContainerClass() {
                return ContainerDraconiumChest.class;
            }

            public ResourceLocation getRecipeCategoryUid() {
                return VanillaRecipeCategoryUid.CRAFTING;
            }

            public boolean canHandle(ContainerDraconiumChest container) {
                return true;
            }

            public List<Slot> getRecipeSlots(ContainerDraconiumChest container) {
                return container.craftInputSlots;
            }

            public List<Slot> getInventorySlots(ContainerDraconiumChest container) {
                return Stream.of(container.mainSlots, container.playerSlots).flatMap(Collection::stream).collect(Collectors.toList());
            }
        });
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<ContainerDraconiumChest>(){

            public Class<ContainerDraconiumChest> getContainerClass() {
                return ContainerDraconiumChest.class;
            }

            public ResourceLocation getRecipeCategoryUid() {
                return VanillaRecipeCategoryUid.FURNACE;
            }

            public boolean canHandle(ContainerDraconiumChest container) {
                return true;
            }

            public List<Slot> getRecipeSlots(ContainerDraconiumChest container) {
                return container.furnaceInputSlots;
            }

            public List<Slot> getInventorySlots(ContainerDraconiumChest container) {
                return Stream.of(container.mainSlots, container.playerSlots).flatMap(Collection::stream).collect(Collectors.toList());
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)DEContent.crafting_core), new ResourceLocation[]{RecipeCategoryUids.FUSION_CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)DEContent.draconium_chest), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING, VanillaRecipeCategoryUid.FURNACE});
    }

    private void hideFeature(Object feature) {
    }

    public void onRuntimeAvailable(IJeiRuntime iJeiRuntime) {
        jeiRuntime = iJeiRuntime;
    }

    public static void reloadJEI() {
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("draconicevolution", "jei_plugin");
    }
}

