/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.draconicevolution.init.EquipCfg;
import java.util.function.Supplier;
import net.minecraft.item.IItemTier;
import net.minecraft.item.crafting.Ingredient;

public class DEItemTier
implements IItemTier {
    private TechPropBuilder itemProps;
    private TechLevel techLevel;
    private Supplier<Float> damageMultiplier;
    private Supplier<Float> speedMultiplier;
    private Supplier<Float> efficiencyMultiplier;

    public DEItemTier(TechPropBuilder itemProps, Supplier<Float> damageMultiplier, Supplier<Float> speedMultiplier) {
        this.itemProps = itemProps;
        this.techLevel = itemProps.techLevel;
        this.damageMultiplier = damageMultiplier;
        this.speedMultiplier = speedMultiplier;
    }

    public DEItemTier(TechPropBuilder itemProps, Supplier<Float> damageMultiplier, Supplier<Float> speedMultiplier, Supplier<Float> efficiencyMultiplier) {
        this(itemProps, damageMultiplier, speedMultiplier);
        this.efficiencyMultiplier = efficiencyMultiplier;
    }

    public int func_200926_a() {
        return 0;
    }

    public int func_200925_d() {
        return this.itemProps.miningLevel;
    }

    public int func_200927_e() {
        return DEItemTier.getEnchantability(this.techLevel);
    }

    public static int getEnchantability(TechLevel techLevel) {
        switch (techLevel) {
            case DRACONIUM: {
                return EquipCfg.draconiumEnchantability;
            }
            case WYVERN: {
                return EquipCfg.wyvernEnchantability;
            }
            case DRACONIC: {
                return EquipCfg.draconicEnchantability;
            }
            case CHAOTIC: {
                return EquipCfg.chaoticEnchantability;
            }
        }
        return 22;
    }

    public float func_200928_b() {
        switch (this.techLevel) {
            case DRACONIUM: {
                return (float)EquipCfg.draconiumEfficiency * (this.efficiencyMultiplier == null ? 1.0f : this.efficiencyMultiplier.get().floatValue());
            }
            case WYVERN: {
                return (float)EquipCfg.wyvernEfficiency * (this.efficiencyMultiplier == null ? 1.0f : this.efficiencyMultiplier.get().floatValue());
            }
            case DRACONIC: {
                return (float)EquipCfg.draconicEfficiency * (this.efficiencyMultiplier == null ? 1.0f : this.efficiencyMultiplier.get().floatValue());
            }
            case CHAOTIC: {
                return (float)EquipCfg.chaoticEfficiency * (this.efficiencyMultiplier == null ? 1.0f : this.efficiencyMultiplier.get().floatValue());
            }
        }
        return 1.0f;
    }

    public float func_200929_c() {
        switch (this.techLevel) {
            case DRACONIUM: {
                return (float)EquipCfg.draconiumDamage * this.damageMultiplier.get().floatValue();
            }
            case WYVERN: {
                return (float)EquipCfg.wyvernDamage * this.damageMultiplier.get().floatValue();
            }
            case DRACONIC: {
                return (float)EquipCfg.draconicDamage * this.damageMultiplier.get().floatValue();
            }
            case CHAOTIC: {
                return (float)EquipCfg.chaoticDamage * this.damageMultiplier.get().floatValue();
            }
        }
        return 1.0f;
    }

    public float getAttackSpeed() {
        switch (this.techLevel) {
            case DRACONIUM: {
                return (float)(EquipCfg.draconiumSpeed * (double)this.speedMultiplier.get().floatValue());
            }
            case WYVERN: {
                return (float)(EquipCfg.wyvernSpeed * (double)this.speedMultiplier.get().floatValue());
            }
            case DRACONIC: {
                return (float)(EquipCfg.draconicSpeed * (double)this.speedMultiplier.get().floatValue());
            }
            case CHAOTIC: {
                return (float)(EquipCfg.chaoticSpeed * (double)this.speedMultiplier.get().floatValue());
            }
        }
        return 1.0f;
    }

    public Ingredient func_200924_f() {
        return Ingredient.field_193370_a;
    }
}

