/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class WorldGenEnderComet {
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private int tailX;
    private int tailY;
    private int tailZ;
    private int size;
    private static ChunkPos popPos = null;
    private static ObfMapping mapping = new ObfMapping("net/minecraft/world/chunk/Chunk", "populating");

    private void initialize(Random rand, int x, int y, int z) {
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
        double rotation = rand.nextInt();
        double xmod = Math.sin(rotation);
        double zmod = Math.cos(rotation);
        int distMod = 150 + rand.nextInt(50);
        this.tailX = x + (int)(xmod * (double)distMod);
        this.tailY = y + 40 + rand.nextInt(40);
        this.tailZ = z + (int)(zmod * (double)distMod);
        this.size = 2 + rand.nextInt(8);
    }

    public boolean generate(World world, Random random, BlockPos pos) {
        this.initialize(random, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        WorldGenEnderComet.setCascadingWarningEnabled(false);
        this.generateCore(world, random, this.size);
        this.generateTrail(world, random);
        WorldGenEnderComet.setCascadingWarningEnabled(true);
        return true;
    }

    private void generateCore(World world, Random rand, int r) {
    }

    private void generateTrail(World world, Random rand) {
        int xDiff = this.tailX - this.spawnX;
        int yDiff = this.tailY - this.spawnY;
        int zDiff = this.tailZ - this.spawnZ;
        for (int p = 0; p < 100; p += 2) {
            int cX = this.spawnX + (int)((float)p / 100.0f * (float)xDiff);
            int cY = this.spawnY + (int)((float)p / 100.0f * (float)yDiff);
            int cZ = this.spawnZ + (int)((float)p / 100.0f * (float)zDiff);
            float pc = (float)p / 100.0f;
            int density = 500 - (int)(pc * 550.0f);
            if (density < 20) {
                density = 20;
            }
            this.generateTrailSphere(world, cX, cY, cZ, this.size + 3 - (int)(pc * (float)(this.size - 2)), density, rand);
            density = 1000 - (int)(pc * 10000.0f);
            this.generateTrailSphere(world, cX, cY, cZ, this.size + 3 - (int)(pc * (float)(this.size - 2)), density, rand);
        }
    }

    public void generateTrailSphere(World world, int xi, int yi, int zi, int r, int density, Random rand) {
    }

    public static double getDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static void setCascadingWarningEnabled(boolean enabled) {
        try {
            if (enabled) {
                ReflectionManager.setField((ObfMapping)mapping, null, (Object)popPos);
                popPos = null;
            } else {
                popPos = (ChunkPos)ReflectionManager.getField((ObfMapping)mapping, null);
                ReflectionManager.setField((ObfMapping)mapping, null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

