/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.armorEffects.ArmorEffect;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class WeaponEfficiency
extends ArmorEffect {
    private final float damage;
    private final Class weapon;

    public WeaponEfficiency(float damage, Class items) {
        this.damage = damage;
        this.weapon = items;
    }

    @Override
    public void appendTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        TranslationTextComponent weaponText = new TranslationTextComponent("armorEffect.weaponEfficiency." + this.weapon.getSimpleName());
        tooltip.add((ITextComponent)new TranslationTextComponent("armorEffect.weaponEfficiency", new Object[]{(int)(this.damage * 100.0f), weaponText}).func_240699_a_(TextFormatting.GOLD));
    }

    @Override
    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        boolean hasAxe;
        LivingEntity attacker;
        if (!source.func_76352_a() && source.func_76346_g() instanceof LivingEntity && this.isPrimaryArmor(armor, attacker = (LivingEntity)source.func_76346_g()) && (hasAxe = Stream.of(attacker.func_184582_a(EquipmentSlotType.MAINHAND), attacker.func_184582_a(EquipmentSlotType.OFFHAND)).filter(Objects::nonNull).anyMatch(v -> this.weapon.isInstance(v.func_77973_b())))) {
            amount *= 1.0f + (float)this.getSetCount(armor, attacker) * this.damage;
        }
        return amount;
    }
}

