/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.armorEffects.ArmorEffect;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class WitherArmorEffect
extends ArmorEffect {
    private final float immunity;
    private final int wither;

    public WitherArmorEffect(float immunity, int wither) {
        this.immunity = immunity;
        this.wither = wither;
    }

    @Override
    public void appendTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        tooltip.add((ITextComponent)new TranslationTextComponent("armorEffect.wither", new Object[]{this.wither}).func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        if (this.isPrimaryArmor(armor, entity) && source.func_76346_g() != null && !source.func_76346_g().func_230279_az_()) {
            LivingEntity livingEntity = (LivingEntity)source.func_76346_g();
            livingEntity.func_195064_c(new EffectInstance(Effects.field_82731_v, this.wither * this.getSetCount(armor, entity)));
        }
        if (Objects.equals(source.field_76373_n, "wither")) {
            return amount * (1.0f - this.immunity);
        }
        return amount;
    }
}

