/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import immersive_armors.client.render.entity.model.DecoModel;
import immersive_armors.client.render.entity.model.GearModel;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.Nullable;

public class GearPiece<M extends GearModel>
extends Piece {
    private final M model;
    private final String texture;
    private final float x;
    private final float y;
    private final float z;
    private final float speed;
    private final Quaternion rotation;

    private ResourceLocation getTexture(ExtendedArmorItem item) {
        return new ResourceLocation("immersive_armors", "textures/models/armor/" + item.getMaterial().func_200897_d() + "/" + this.texture + ".png");
    }

    public GearPiece(M model, String texture, float x, float y, float z, float speed) {
        this(model, texture, x, y, z, speed, null);
    }

    public GearPiece(M model, String texture, float x, float y, float z, float speed, @Nullable Quaternion rotation) {
        this.model = model;
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.z = z;
        this.speed = speed;
        this.rotation = rotation;
    }

    @Override
    public void render(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, LivingEntity entity, ItemStack itemStack, float tickDelta, EquipmentSlotType armorSlot, BipedModel<LivingEntity> contextModel) {
        matrices.func_227860_a_();
        DecoModel.getModelPart(contextModel, ((GearModel)((Object)this.model)).getAttachTo()).func_228307_a_(matrices);
        matrices.func_227861_a_((double)this.x, (double)this.y, (double)this.z);
        if (this.rotation != null) {
            matrices.func_227863_a_(this.rotation);
        }
        matrices.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), ((float)entity.field_70173_aa + tickDelta) * this.speed, false));
        IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(RenderType.func_239263_a_((ResourceLocation)this.getTexture((ExtendedArmorItem)itemStack.func_77973_b())));
        ((GearModel)((Object)this.model)).getPart().func_228309_a_(matrices, vertexConsumer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.func_227865_b_();
    }
}

