/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import immersive_armors.item.ExtendedArmorItem;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class Piece {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_CACHE = Maps.newHashMap();
    private boolean translucent;
    private boolean glint;
    private boolean colored;
    private boolean glowing;
    private String texture;

    protected void setVisible(BipedModel bipedModel, EquipmentSlotType slot) {
        bipedModel.func_178719_a(false);
        switch (slot) {
            case HEAD: {
                bipedModel.field_78116_c.field_78806_j = true;
                bipedModel.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                bipedModel.field_78115_e.field_78806_j = true;
                bipedModel.field_178723_h.field_78806_j = true;
                bipedModel.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                bipedModel.field_78115_e.field_78806_j = true;
                bipedModel.field_178721_j.field_78806_j = true;
                bipedModel.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                bipedModel.field_178721_j.field_78806_j = true;
                bipedModel.field_178722_k.field_78806_j = true;
            }
        }
    }

    private ResourceLocation getTexture(ExtendedArmorItem item, boolean overlay) {
        String string = "immersive_armors:textures/models/armor/" + item.getMaterial().func_200897_d() + "/" + this.getTexture() + (overlay ? "_overlay" : "") + ".png";
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(string, ResourceLocation::new);
    }

    protected void renderParts(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, ExtendedArmorItem item, EntityModel model, float red, float green, float blue, boolean overlay) {
        RenderType renderLayer = this.isTranslucent() ? RenderType.func_228644_e_((ResourceLocation)this.getTexture(item, overlay)) : (this.isGlowing() ? RenderType.func_228637_a_((ResourceLocation)this.getTexture(item, overlay), (boolean)false) : RenderType.func_239263_a_((ResourceLocation)this.getTexture(item, overlay)));
        IVertexBuilder vertexConsumer = ItemRenderer.func_239386_a_((IRenderTypeBuffer)vertexConsumers, (RenderType)renderLayer, (boolean)false, (boolean)this.hasGlint());
        model.func_225598_a_(matrices, vertexConsumer, light, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    public abstract void render(MatrixStack var1, IRenderTypeBuffer var2, int var3, LivingEntity var4, ItemStack var5, float var6, EquipmentSlotType var7, BipedModel<LivingEntity> var8);

    public Piece translucent() {
        this.translucent = true;
        return this;
    }

    public Piece glint() {
        this.glint = true;
        return this;
    }

    public Piece colored() {
        this.colored = true;
        return this;
    }

    public Piece glowing() {
        this.glowing = true;
        return this;
    }

    public Piece texture(String texture) {
        this.texture = texture;
        return this;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public boolean hasGlint() {
        return this.glint;
    }

    public boolean isColored() {
        return this.colored;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public String getTexture() {
        return this.texture;
    }
}

