/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import immersive_armors.armorEffects.ArmorEffect;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ExtendedArmorItem
extends ArmorItem {
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final ExtendedArmorMaterial material;

    public ExtendedArmorItem(Item.Properties settings, EquipmentSlotType slot, ExtendedArmorMaterial material) {
        super((IArmorMaterial)material, slot, settings);
        this.material = material;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uUID = MODIFIERS[slot.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uUID, "Armor modifier", (double)this.func_200881_e(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uUID, "Armor toughness", (double)this.getMaterial().func_200901_e(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uUID, "Armor knockback resistance", (double)this.field_234655_c_, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(uUID, "Armor movement speed", (double)(-material.getWeight()), AttributeModifier.Operation.MULTIPLY_TOTAL));
        builder.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(uUID, "Armor health gain", (double)material.getExtraHealth(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(uUID, "Armor attack bonus", (double)material.getAttackDamage(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(uUID, "Armor attack damage", (double)material.getAttackSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        builder.put((Object)Attributes.field_233828_k_, (Object)new AttributeModifier(uUID, "Armor luck", (double)material.getLuck(), AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == this.field_77881_a ? this.attributeModifiers : super.func_111205_h(slot);
    }

    public ExtendedArmorMaterial getMaterial() {
        return this.material;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.func_77624_a(stack, world, tooltip, context);
        for (ArmorEffect armorEffect : this.getMaterial().getEffects()) {
            armorEffect.appendTooltip(stack, world, tooltip, context);
        }
        for (Map.Entry entry : this.getMaterial().getEnchantments().entrySet()) {
            tooltip.add(((Enchantment)entry.getKey()).func_200305_d(((Integer)entry.getValue()).intValue()));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        LivingEntity livingEntity;
        ItemStack equippedStack;
        super.func_77663_a(stack, world, entity, slot, selected);
        if (entity instanceof LivingEntity && (equippedStack = (livingEntity = (LivingEntity)entity).func_184582_a(this.func_185083_B_())) == stack) {
            for (ArmorEffect e : this.getMaterial().getEffects()) {
                e.equippedTick(stack, world, livingEntity, slot);
            }
        }
    }

    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        for (ArmorEffect e : this.getMaterial().getEffects()) {
            amount = e.applyArmorToDamage(entity, source, amount, armor);
        }
        return amount;
    }

    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        for (ArmorEffect e : this.getMaterial().getEffects()) {
            amount = e.applyArmorToAttack(target, source, amount, armor);
        }
        return amount;
    }
}

