/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BipedArmorLayer.class})
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    public MixinArmorFeatureRenderer(IEntityRenderer<T, M> context) {
        super(context);
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    void renderArmor(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, T entity, EquipmentSlotType armorSlot, int light, A model, CallbackInfo ci) {
        ItemStack itemStack = entity.func_184582_a(armorSlot);
        if (itemStack.func_77973_b() instanceof ExtendedArmorItem) {
            ci.cancel();
        }
    }

    private void renderDecoModels(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, T entity, EquipmentSlotType armorSlot, int light, float tickDelta) {
        ExtendedArmorItem armorItem;
        ItemStack itemStack = entity.func_184582_a(armorSlot);
        if (itemStack.func_77973_b() instanceof ExtendedArmorItem && (armorItem = (ExtendedArmorItem)itemStack.func_77973_b()).func_185083_B_() == armorSlot) {
            armorItem.getMaterial().getPieces(armorSlot).forEach(piece -> piece.render(matrices, vertexConsumers, light, (LivingEntity)entity, itemStack, tickDelta, armorSlot, (BipedModel<LivingEntity>)((BipedModel)this.func_215332_c())));
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void render(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, T entity, float f, float g, float tickDelta, float j, float k, float l, CallbackInfo ci) {
        this.renderDecoModels(matrixStack, vertexConsumerProvider, entity, EquipmentSlotType.HEAD, i, tickDelta);
        this.renderDecoModels(matrixStack, vertexConsumerProvider, entity, EquipmentSlotType.CHEST, i, tickDelta);
        this.renderDecoModels(matrixStack, vertexConsumerProvider, entity, EquipmentSlotType.LEGS, i, tickDelta);
        this.renderDecoModels(matrixStack, vertexConsumerProvider, entity, EquipmentSlotType.FEET, i, tickDelta);
    }
}

