/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    protected MixinLivingEntity(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Shadow
    public abstract ItemStack func_184582_a(EquipmentSlotType var1);

    private float apply(EquipmentSlotType slot, DamageSource source, float amount) {
        ItemStack stack = this.func_184582_a(slot);
        if (stack != null && stack.func_77973_b() instanceof ExtendedArmorItem) {
            ExtendedArmorItem armor = (ExtendedArmorItem)stack.func_77973_b();
            if (this instanceof LivingEntity) {
                amount = armor.applyArmorToDamage((LivingEntity)this, source, amount, stack);
            }
        }
        return amount;
    }

    private float applyToAttacker(LivingEntity attacker, EquipmentSlotType slot, DamageSource source, float amount) {
        ItemStack stack = attacker.func_184582_a(slot);
        if (stack != null && stack.func_77973_b() instanceof ExtendedArmorItem) {
            ExtendedArmorItem armor = (ExtendedArmorItem)stack.func_77973_b();
            if (this instanceof LivingEntity) {
                amount = armor.applyArmorToAttack((LivingEntity)this, source, amount, stack);
            }
        }
        return amount;
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="RETURN")}, cancellable=true)
    void applyArmorToDamage(DamageSource source, float unused, CallbackInfoReturnable<Float> cir) {
        float amount = ((Float)cir.getReturnValue()).floatValue();
        amount = this.apply(EquipmentSlotType.HEAD, source, amount);
        amount = this.apply(EquipmentSlotType.CHEST, source, amount);
        amount = this.apply(EquipmentSlotType.LEGS, source, amount);
        amount = this.apply(EquipmentSlotType.FEET, source, amount);
        Entity attacker = source.func_76346_g();
        if (attacker instanceof LivingEntity) {
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlotType.HEAD, source, amount);
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlotType.CHEST, source, amount);
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlotType.LEGS, source, amount);
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlotType.FEET, source, amount);
        }
        cir.setReturnValue((Object)Float.valueOf(amount));
    }
}

