/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachineInsolatorContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;

public class MachineInsolatorTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && InsolatorRecipeManager.instance().validRecipe(item));
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(item -> item.func_77973_b() instanceof SlotSealItem || InsolatorRecipeManager.instance().validCatalyst(item));
    protected FluidStorageCoFH waterTank = new FluidStorageCoFH(4000, FluidHelper.IS_WATER);
    protected boolean cyclicProcessingFeature = false;

    public MachineInsolatorTile() {
        super(TExpReferences.MACHINE_INSOLATOR_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.waterTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return InsolatorRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = InsolatorRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = InsolatorRecipeManager.instance().getCatalyst((IItemStackAccess)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        int primaryCount = (Integer)this.itemInputCounts.get(0);
        if (this.cyclicProcessingFeature) {
            boolean recycled = false;
            ItemStack input = this.inputSlot.getItemStack();
            for (ItemStorageCoFH slot : this.outputSlots()) {
                if (!ItemHelper.itemsEqualWithTags((ItemStack)slot.getItemStack(), (ItemStack)input) || slot.getCount() < primaryCount) continue;
                slot.modify(-primaryCount);
                recycled = true;
                break;
            }
            if (!recycled) {
                this.inputSlot.modify(-primaryCount);
            }
        } else {
            this.inputSlot.modify(-primaryCount);
        }
        int n = decrement = this.itemInputCounts.size() > 1 ? (Integer)this.itemInputCounts.get(1) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().func_77984_f()) {
                if (this.catalystSlot.getItemStack().func_96631_a(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
        if (!this.fluidInputCounts.isEmpty()) {
            this.waterTank.modify(-((Integer)this.fluidInputCounts.get(0)).intValue());
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineInsolatorContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0) && (this.fluidInputCounts.isEmpty() || this.waterTank.getAmount() >= (Integer)this.fluidInputCounts.get(0));
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.cyclicProcessingFeature = false;
    }

    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.cyclicProcessingFeature |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"CycProc") > 0.0f;
    }
}

