/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.lib.client.audio.ConditionalSound;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.init.TExpSounds;
import cofh.thermal.expansion.inventory.container.machine.MachineSmelterContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;

public class MachineSmelterTile
extends MachineTileProcess {
    protected ItemStorageCoFH[] inputSlots = new ItemStorageCoFH[3];
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(item -> item.func_77973_b() instanceof SlotSealItem || SmelterRecipeManager.instance().validCatalyst(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()));
    protected boolean cyclicProcessingFeature = false;

    public MachineSmelterTile() {
        super(TExpReferences.MACHINE_SMELTER_TILE);
        this.inputSlots[0] = new ItemStorageCoFH(item -> item.func_77973_b() instanceof SlotSealItem || this.filter.valid(item) && SmelterRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.catalystSlot.getItemStack()));
        this.inputSlots[1] = new ItemStorageCoFH(item -> item.func_77973_b() instanceof SlotSealItem || this.filter.valid(item) && SmelterRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.catalystSlot.getItemStack()));
        this.inputSlots[2] = new ItemStorageCoFH(item -> item.func_77973_b() instanceof SlotSealItem || this.filter.valid(item) && SmelterRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.catalystSlot.getItemStack()));
        for (int i = 0; i < 3; ++i) {
            this.inventory.addSlot(this.inputSlots[i], StorageGroup.INPUT);
        }
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return SmelterRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = SmelterRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = SmelterRecipeManager.instance().getCatalyst((IItemStackAccess)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        for (int i = 0; i < 3; ++i) {
            this.inputSlots[i].modify(-((Integer)this.itemInputCounts.get(i)).intValue());
        }
        if (this.cyclicProcessingFeature && !this.catalystSlot.isEmpty() && !this.catalystSlot.isFull()) {
            ItemStack catalyst = this.catalystSlot.getItemStack();
            for (ItemStorageCoFH slot : this.outputSlots()) {
                if (!ItemHelper.itemsEqualWithTags((ItemStack)slot.getItemStack(), (ItemStack)catalyst)) continue;
                slot.modify(-1);
                this.catalystSlot.modify(1);
                break;
            }
        }
        int n = decrement = this.itemInputCounts.size() > 3 ? (Integer)this.itemInputCounts.get(3) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().func_77984_f()) {
                if (this.catalystSlot.getItemStack().func_96631_a(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineSmelterContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSound(TExpSounds.SOUND_MACHINE_SMELTER, SoundCategory.AMBIENT, (TileEntity)this, () -> !this.field_145846_f && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        List slotInputs = this.inputSlots();
        for (int i = 0; i < slotInputs.size() && i < this.itemInputCounts.size(); ++i) {
            int inputCount = (Integer)this.itemInputCounts.get(i);
            if (((ItemStorageCoFH)slotInputs.get(i)).getItemStack().func_190916_E() >= inputCount) continue;
            return false;
        }
        return true;
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.cyclicProcessingFeature = false;
    }

    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.cyclicProcessingFeature |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"CycProc") > 0.0f;
    }
}

