/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.terraintypes.BaseChunkGenerator;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;

public class CommandDump
implements Command<CommandSource> {
    private static final CommandDump CMD = new CommandDump();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump").requires(cs -> cs.func_197034_c(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ResourceLocation location = world.func_234923_W_().func_240901_a_();
        this.feedback(context, TextFormatting.BLUE + "Dimension: " + TextFormatting.WHITE + location.toString());
        DimensionData data = PersistantDimensionManager.get((World)world).getData(location);
        if (data == null) {
            this.feedback(context, TextFormatting.RED + "Not an RFTools Dimensions!");
            return 0;
        }
        this.feedback(context, TextFormatting.BLUE + "Energy: " + TextFormatting.WHITE + data.getEnergy());
        ChunkGenerator generator = world.func_72863_F().field_186029_c;
        if (generator instanceof BaseChunkGenerator) {
            DimensionSettings settings = ((BaseChunkGenerator)generator).getDimensionSettings();
            this.feedback(context, TextFormatting.BLUE + "Seed: " + TextFormatting.WHITE + settings.getSeed());
        }
        DimensionDescriptor descriptor = data.getDescriptor();
        this.feedback(context, TextFormatting.GREEN + "Standard dimlets:");
        for (DimletKey dimlet : descriptor.getDimlets()) {
            this.feedback(context, TextFormatting.BLUE + "    " + dimlet.getType().name() + ": " + TextFormatting.WHITE + dimlet.getKey());
        }
        DimensionDescriptor randomizedDescriptor = data.getRandomizedDescriptor();
        this.feedback(context, TextFormatting.GREEN + "Randomized dimlets:");
        for (DimletKey dimlet : randomizedDescriptor.getDimlets()) {
            this.feedback(context, TextFormatting.BLUE + "    " + dimlet.getType().name() + ": " + TextFormatting.WHITE + dimlet.getKey());
        }
        return 0;
    }

    private void feedback(CommandContext<CommandSource> context, String message) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(message), false);
    }
}

