/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class ClientDimensionData {
    private static final ClientDimensionData INSTANCE = new ClientDimensionData();
    private Map<ResourceLocation, Power> powerMap = new HashMap<ResourceLocation, Power>();
    private long worldSeed = -1L;

    public static ClientDimensionData get() {
        return INSTANCE;
    }

    public long getPower(ResourceLocation id) {
        return this.powerMap.getOrDefault(id, Power.NONE).power;
    }

    public long getMaxPower(ResourceLocation id) {
        return this.powerMap.getOrDefault(id, Power.NONE).max;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void updateDataFromServer(Map<ResourceLocation, Power> powerMap, long seed) {
        this.powerMap = powerMap;
        this.worldSeed = seed;
    }

    public void clear() {
        this.worldSeed = -1L;
        this.powerMap.clear();
    }

    public static class Power {
        private final long power;
        private final long max;
        public static final Power NONE = new Power(-1L, -1L);

        public Power(long power, long max) {
            this.power = power;
            this.max = max;
        }

        public long getPower() {
            return this.power;
        }

        public long getMax() {
            return this.max;
        }
    }
}

