/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features.instances;

import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.dimension.features.IFeature;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;

public class CubeFeature
implements IFeature {
    private final boolean hollow;
    private final boolean liquid;

    public CubeFeature(boolean hollow, boolean liquid) {
        this.hollow = hollow;
        this.liquid = liquid;
    }

    @Override
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, List<BlockState> states, List<BlockState> liquids, long prime) {
        ChunkPos cp = new ChunkPos(pos);
        int chunkX = cp.field_77276_a;
        int chunkZ = cp.field_77275_b;
        int size = 1;
        BlockState filler = Blocks.field_150350_a.func_176223_P();
        boolean generated = false;
        for (int dx = -size; dx <= size; ++dx) {
            int cx = chunkX + dx;
            for (int dz = -size; dz <= size; ++dz) {
                int cz = chunkZ + dz;
                if (!CubeFeature.isFeatureCenter(reader, cx, cz, prime)) continue;
                if (this.liquid) {
                    int index = CubeFeature.getCenteredIndex(reader, cx, cz, prime, liquids.size());
                    filler = liquids.get(index);
                }
                this.generate(reader, chunkX, chunkZ, dx, dz, states, filler, prime);
                generated = true;
            }
        }
        return generated;
    }

    private void generate(ISeedReader world, int chunkX, int chunkZ, int dx, int dz, List<BlockState> states, BlockState filler, long prime) {
        Random random = new Random(world.func_72905_C() + (long)(chunkZ + dz) * prime + (long)(chunkX + dx) * 899809363L);
        random.nextFloat();
        int radius = random.nextInt(12) + 9;
        int centery = random.nextInt(60) + 40;
        int centerx = 8 + dx * 16;
        int centerz = 8 + dz * 16;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            int xdist = Math.abs(x - centerx);
            if (xdist > radius) continue;
            for (int z = 0; z < 16; ++z) {
                int zdist = Math.abs(z - centerz);
                if (zdist > radius) continue;
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    pos.func_181079_c(chunkX * 16 + x, y, chunkZ * 16 + z);
                    if (!this.hollow || y == centery - radius || y == centery + radius || xdist == radius || zdist == radius) {
                        world.func_180501_a((BlockPos)pos, IFeature.select(states, random), 0);
                        continue;
                    }
                    world.func_180501_a((BlockPos)pos, filler, 0);
                }
            }
        }
    }

    private static int getCenteredIndex(ISeedReader world, int chunkX, int chunkZ, long prime, int max) {
        if (max == 1) {
            return 0;
        }
        Random random = new Random((long)chunkX * 343457327L + (long)chunkZ * prime ^ world.func_72905_C());
        random.nextFloat();
        return random.nextInt(max);
    }

    private static boolean isFeatureCenter(ISeedReader world, int chunkX, int chunkZ, long prime) {
        double factor = 0.05f;
        Random random = new Random((long)chunkX * prime + (long)chunkZ * 343457327L ^ world.func_72905_C());
        random.nextFloat();
        double value = random.nextFloat();
        return value < factor;
    }
}

