/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PackagePropageDataToClients {
    private final Map<ResourceLocation, ClientDimensionData.Power> powerMap;
    private final long seed;

    public PackagePropageDataToClients(PacketBuffer buf) {
        int size = buf.readInt();
        this.powerMap = new HashMap<ResourceLocation, ClientDimensionData.Power>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.func_192575_l();
            long power = buf.readLong();
            long max = buf.readLong();
            this.powerMap.put(id, new ClientDimensionData.Power(power, max));
        }
        this.seed = buf.readLong();
    }

    public PackagePropageDataToClients(Map<ResourceLocation, ClientDimensionData.Power> powerMap, long seed) {
        this.powerMap = powerMap;
        this.seed = seed;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.powerMap.size());
        for (Map.Entry<ResourceLocation, ClientDimensionData.Power> entry : this.powerMap.entrySet()) {
            buf.func_192572_a(entry.getKey());
            buf.writeLong(entry.getValue().getPower());
            buf.writeLong(entry.getValue().getMax());
        }
        buf.writeLong(this.seed);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientDimensionData.get().updateDataFromServer(this.powerMap, this.seed));
        ctx.setPacketHandled(true);
    }
}

