/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.blob.client.DimensionalBlobModel;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class DimensionalBlobRender
extends LivingRenderer<DimensionalBlobEntity, DimensionalBlobModel<DimensionalBlobEntity>> {
    private static final ResourceLocation TEXTURE_COMMON = new ResourceLocation("rftoolsdim", "textures/entity/dimensional_blob_common.png");
    private static final ResourceLocation TEXTURE_RARE = new ResourceLocation("rftoolsdim", "textures/entity/dimensional_blob_rare.png");
    private static final ResourceLocation TEXTURE_LEGENDARY = new ResourceLocation("rftoolsdim", "textures/entity/dimensional_blob_legendary.png");
    public static final Factory FACTORY = new Factory();

    public DimensionalBlobRender(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new DimensionalBlobModel(), 0.8f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(DimensionalBlobEntity entity) {
        switch (entity.getRarity()) {
            case COMMON: {
                return TEXTURE_COMMON;
            }
            case UNCOMMON: {
                return TEXTURE_COMMON;
            }
            case RARE: {
                return TEXTURE_RARE;
            }
            case LEGENDARY: {
                return TEXTURE_LEGENDARY;
            }
        }
        return TEXTURE_COMMON;
    }

    protected boolean shouldShowName(DimensionalBlobEntity entity) {
        return entity.func_145818_k_() && super.func_177070_b((LivingEntity)entity);
    }

    protected void scale(DimensionalBlobEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = 0.999f;
        matrixStackIn.func_227862_a_(0.999f, 0.999f, 0.999f);
        matrixStackIn.func_227861_a_(0.0, (double)0.301f, 0.0);
        float f1 = 2.0f * entitylivingbaseIn.func_213355_cm();
        float f2 = MathHelper.func_219799_g((float)partialTickTime, (float)entitylivingbaseIn.prevSquishFactor, (float)entitylivingbaseIn.squishFactor) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        matrixStackIn.func_227862_a_(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public static class Factory
    implements IRenderFactory<DimensionalBlobEntity> {
        public EntityRenderer<? super DimensionalBlobEntity> createRenderFor(EntityRendererManager manager) {
            return new DimensionalBlobRender(manager);
        }
    }
}

