/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.tools;

import java.util.Random;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.modules.blob.BlobModule;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class Spawner {
    public static void spawnOne(ServerWorld world, PlayerEntity player, CompiledDescriptor compiledDescriptor, DimensionData data, Random random) {
        double distanceX = random.nextDouble() * 100.0 - 50.0;
        double distanceZ = random.nextDouble() * 100.0 - 50.0;
        while (distanceX < 22.0 && distanceZ < 22.0) {
            distanceX = random.nextDouble() * 100.0 - 50.0;
            distanceZ = random.nextDouble() * 100.0 - 50.0;
        }
        int x = (int)(player.func_226277_ct_() + distanceX);
        int z = (int)(player.func_226281_cx_() + distanceZ);
        EntityType<DimensionalBlobEntity> type = Spawner.randomBlob(compiledDescriptor, data, random);
        BlockPos pos = Spawner.getValidSpawnablePosition(random, (IWorldReader)world, x, z);
        if (pos == null) {
            return;
        }
        boolean nocollisions = world.func_226664_a_(type.func_220328_a((double)x, (double)pos.func_177956_o(), (double)z));
        boolean canSpawn = true;
        if (!nocollisions || !canSpawn) {
            return;
        }
        DimensionalBlobEntity entity = (DimensionalBlobEntity)type.func_200721_a((World)world);
        entity.func_70012_b(x, pos.func_177956_o(), z, random.nextFloat() * 360.0f, 0.0f);
        if (ForgeHooks.canEntitySpawn((MobEntity)entity, (IWorld)world, (double)x, (double)pos.func_177956_o(), (double)z, null, (SpawnReason)SpawnReason.NATURAL) == -1) {
            return;
        }
        if (entity.func_213380_a((IWorld)world, SpawnReason.NATURAL) && entity.func_205019_a((IWorldReader)world)) {
            entity.func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.NATURAL, null, null);
            world.func_242417_l((Entity)entity);
        }
    }

    private static EntityType<DimensionalBlobEntity> randomBlob(CompiledDescriptor compiledDescriptor, DimensionData data, Random random) {
        float perTick = compiledDescriptor != null ? (float)compiledDescriptor.getActualPowerCost() : 0.0f;
        perTick = Math.min(perTick, 50000.0f);
        float rareChance = 0.1f + perTick / 150000.0f;
        if (random.nextFloat() < rareChance) {
            if (random.nextFloat() < rareChance) {
                return (EntityType)BlobModule.DIMENSIONAL_BLOB_LEGENDARY.get();
            }
            return (EntityType)BlobModule.DIMENSIONAL_BLOB_RARE.get();
        }
        return (EntityType)BlobModule.DIMENSIONAL_BLOB_COMMON.get();
    }

    @Nullable
    private static BlockPos getValidSpawnablePosition(Random random, IWorldReader worldIn, int x, int z) {
        int height = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
        if (height <= 3) {
            return null;
        }
        height = random.nextInt(height - 3) + 3;
        BlockPos blockPos = new BlockPos(x, height - 1, z);
        while (!Spawner.isValidSpawnPos(worldIn, blockPos)) {
            if ((blockPos = blockPos.func_177977_b()).func_177956_o() > 1) continue;
            return null;
        }
        return blockPos;
    }

    private static boolean isValidSpawnPos(IWorldReader world, BlockPos pos) {
        if (!world.func_180495_p(pos).func_196957_g((IBlockReader)world, pos, PathType.LAND)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_200132_m();
    }
}

