/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidAbsorberTileEntity
extends TickingTileEntity {
    private static final int ABSORB_SPEED = 2;
    private int absorbing = 0;
    private Block absorbingBlock = null;
    private int timer = 2;
    private final Set<BlockPos> toscan = new HashSet<BlockPos>();
    private final FakePlayerGetter harvester = new FakePlayerGetter((GenericTileEntity)this, "rftools_fluid_absorber");

    public FluidAbsorberTileEntity() {
        super((TileEntityType)EssencesModule.TYPE_FLUID_ABSORBER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()).tileEntitySupplier(FluidAbsorberTileEntity::new).manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"fluid", FluidAbsorberTileEntity::getFluidName), TooltipBuilder.parameter((String)"progress", FluidAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getFluidName(ItemStack stack) {
        String block = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"fluid", null);
        if (block == null) {
            return "<Not Set>";
        }
        Fluid b = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(block));
        if (b != null) {
            return I18n.func_135052_a((String)b.func_207188_f().func_206883_i().func_177230_c().func_149739_a(), (Object[])new Object[0]);
        }
        return "<Invalid>";
    }

    public static String getFluid(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"fluid", null);
    }

    private static String getProgressName(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxFluidAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxFluidAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
    }

    protected void tickServer() {
        if (this.absorbing > 0 || this.absorbingBlock == null) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 2;
                BlockState b = this.isValidSourceBlock(this.func_174877_v().func_177977_b());
                if (b != null) {
                    if (this.absorbingBlock == null) {
                        this.absorbing = (Integer)EssencesConfig.maxFluidAbsorption.get();
                        this.absorbingBlock = b.func_177230_c();
                        this.toscan.clear();
                    }
                    this.toscan.add(this.func_174877_v().func_177977_b());
                }
                if (!this.toscan.isEmpty()) {
                    int r = this.field_145850_b.field_73012_v.nextInt(this.toscan.size());
                    Iterator<BlockPos> iterator = this.toscan.iterator();
                    BlockPos c = null;
                    for (int i = 0; i <= r; ++i) {
                        c = iterator.next();
                    }
                    this.toscan.remove(c);
                    this.checkBlock(c, Direction.DOWN);
                    this.checkBlock(c, Direction.UP);
                    this.checkBlock(c, Direction.EAST);
                    this.checkBlock(c, Direction.WEST);
                    this.checkBlock(c, Direction.SOUTH);
                    this.checkBlock(c, Direction.NORTH);
                    if (this.blockMatches(c)) {
                        BlockState oldState = this.field_145850_b.func_180495_p(c);
                        FluidState oldFluidState = this.field_145850_b.func_204610_c(c);
                        SoundTools.playSound((World)this.field_145850_b, (SoundEvent)this.absorbingBlock.getSoundType(oldFluidState.func_206883_i(), (IWorldReader)this.field_145850_b, c, null).func_185845_c(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
                        BlockPos finalC = c;
                        FluidTools.pickupFluidBlock((World)this.field_145850_b, (BlockPos)c, s -> true, () -> this.field_145850_b.func_180501_a(finalC, Blocks.field_150350_a.func_176223_P(), 2));
                        --this.absorbing;
                        BlockState newState = this.field_145850_b.func_180495_p(c);
                        this.field_145850_b.func_184138_a(c, oldState, newState, 3);
                    }
                }
            }
            this.func_70296_d();
        }
    }

    protected void tickClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    private void checkBlock(BlockPos c, Direction direction) {
        BlockPos c2 = c.func_177972_a(direction);
        if (this.blockMatches(c2)) {
            this.toscan.add(c2);
        }
    }

    private boolean blockMatches(BlockPos c) {
        FluidState state = this.field_145850_b.func_204610_c(c);
        if (!state.func_206889_d()) {
            return false;
        }
        return state.func_206883_i().func_177230_c().equals(this.absorbingBlock);
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public Block getAbsorbingBlock() {
        return this.absorbingBlock;
    }

    public Fluid getAbsorbingFluid() {
        if (this.absorbingBlock != null) {
            return this.absorbingBlock.func_176223_P().func_204520_s().func_206886_c();
        }
        return null;
    }

    private BlockState isValidSourceBlock(BlockPos coordinate) {
        if (!BlockAbsorberTileEntity.allowedToBreak(this.field_145850_b.func_180495_p(coordinate), this.field_145850_b, coordinate, (PlayerEntity)this.harvester.get())) {
            return null;
        }
        FluidState state = this.field_145850_b.func_204610_c(coordinate);
        if (this.isValidDimletFluid(state)) {
            return state.func_206883_i();
        }
        return null;
    }

    private boolean isValidDimletFluid(FluidState fluidState) {
        if (fluidState != null && !fluidState.func_206888_e()) {
            if (!fluidState.func_206889_d()) {
                return false;
            }
            Fluid fluid = fluidState.func_206886_c();
            DimletKey key = new DimletKey(DimletType.FLUID, fluid.getRegistryName().toString());
            DimletSettings settings = DimletDictionary.get().getSettings(key);
            return settings != null && settings.isDimlet();
        }
        return false;
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        int[] x = tagCompound.func_74759_k("toscanx");
        int[] y = tagCompound.func_74759_k("toscany");
        int[] z = tagCompound.func_74759_k("toscanz");
        this.toscan.clear();
        for (int i = 0; i < x.length; ++i) {
            this.toscan.add(new BlockPos(x[i], y[i], z[i]));
        }
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            Fluid fluid;
            CompoundNBT info = tagCompound.func_74775_l("Info");
            this.absorbing = info.func_74762_e("absorbing");
            if (info.func_74764_b("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(info.func_74779_i("fluid")))) != null) {
                this.absorbingBlock = fluid.func_207188_f().func_206883_i().func_177230_c();
            }
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        int[] x = new int[this.toscan.size()];
        int[] y = new int[this.toscan.size()];
        int[] z = new int[this.toscan.size()];
        int i = 0;
        for (BlockPos c : this.toscan) {
            x[i] = c.func_177958_n();
            y[i] = c.func_177956_o();
            z[i] = c.func_177952_p();
            ++i;
        }
        tagCompound.func_74783_a("toscanx", x);
        tagCompound.func_74783_a("toscany", y);
        tagCompound.func_74783_a("toscanz", z);
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("absorbing", this.absorbing);
        if (this.absorbingBlock != null) {
            info.func_74778_a("fluid", this.absorbingBlock.func_176223_P().func_204520_s().func_206886_c().getRegistryName().toString());
        }
    }
}

